package arm32x.minecraft.commandblockide.client.gui.editor;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.client.gui.Container;
import arm32x.minecraft.commandblockide.client.gui.MultilineTextFieldWidget;
import arm32x.minecraft.commandblockide.client.processor.CommandProcessor;
import arm32x.minecraft.commandblockide.client.processor.MultilineCommandProcessor;
import arm32x.minecraft.commandblockide.client.processor.StringMapping;
import arm32x.minecraft.commandblockide.mixin.client.ChatInputSuggestorAccessor;
import arm32x.minecraft.commandblockide.mixinextensions.client.ChatInputSuggestorExtension;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Environment(EnvType.CLIENT)
public abstract class CommandEditor extends Container implements Dirtyable {
    private final int x;
    private int y;
    private int width;
    private int height;

    private final int leftPadding, rightPadding;

    public final int index;
    public boolean lineNumberHighlighted = false;

    protected final class_327 textRenderer;

    protected final MultilineTextFieldWidget commandField;
    protected final class_4717 suggestor;
    protected final CommandProcessor processor = MultilineCommandProcessor.getInstance();

    private boolean suggestorActive = false;

    private boolean loaded = false;

    protected @Nullable IntConsumer heightChangedListener = null;

    @SuppressWarnings("ConstantConditions")
    public CommandEditor(class_437 screen, class_327 textRenderer, int x, int y, int width, int height, int leftPadding, int rightPadding, int index) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.leftPadding = leftPadding;
        this.rightPadding = rightPadding;
        this.index = index;
        this.textRenderer = textRenderer;

        commandField = addSelectableChild(new MultilineTextFieldWidget(
                textRenderer,
                x + leftPadding + 20, y,
                width - leftPadding - rightPadding - 20, height,
                class_2561.method_43471("advMode.command")
                        .method_10852(class_2561.method_43469("commandBlockIDE.narrator.editorIndex", index + 1))
        ) {
            @Override
            protected class_5250 method_25360() {
                return super.method_25360().method_10852(suggestor.method_23958());
            }
        });
        commandField.method_1888(false);
        commandField.method_1880(Integer.MAX_VALUE);

        suggestor = new class_4717(class_310.method_1551(), screen, commandField, textRenderer, true, true, 0, 16, false, Integer.MIN_VALUE);
        ((ChatInputSuggestorExtension) suggestor).ide$setCommandProcessor(processor);
        suggestor.method_23934();

        commandField.method_1863(this::commandChanged);
        commandField.setCursorChangeListener(suggestor::method_23934);
        commandField.setSyntaxHighlighter((text) -> {
            var parse = ((ChatInputSuggestorAccessor) suggestor).getParse();
            if (parse != null) {
                return highlight(parse, text, processor.processCommand(text).method_15441());
            } else {
                // The command hasn't been parsed yet, so we show it without
                // highlighting. I haven't ever seen this in game, though.
                return MultilineTextFieldWidget.SyntaxHighlighter.NONE.highlight(text);
            }
        });
    }

    public void commandChanged(String newCommand) {
        suggestor.method_23934();
        setHeight(commandField.getLineCount() * commandField.getLineHeight() + 4);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (handleSpecialKey(input)) {
            return true;
        } else if (isSuggestorActive() && suggestor.method_23924(input)) {
            return true;
        } else if (commandField.method_25404(input)) {
            // Movement commands such as arrow keys should hide the suggestion
            // window since it's likely the user will want to move up or down.
            setSuggestorActive(false);
            return true;
        } else {
            return false;
        }
    }

    private boolean handleSpecialKey(class_11908 input) {
        if (
                input.comp_4795() == GLFW.GLFW_KEY_TAB
                        && !isSuggestorActive()
                        && !commandField.isBeforeFirstNonWhitespaceCharacterInLine(commandField.method_1881())
        ) {
            setSuggestorActive(true);
            suggestor.method_23934();
            // Immediately trigger completion without using Mixin by
            // simulating a key press. The scancode and modifiers arguments
            // are never used.
            return suggestor.method_23924(new class_11908(GLFW.GLFW_KEY_TAB, -1, 0));
        } else if (input.comp_4795() == GLFW.GLFW_KEY_SPACE && input.method_74240()) {
            setSuggestorActive(true);
            suggestor.method_23920(true);
            return true;
        }
        // The Escape key is handled in CommandIDEScreen, not here.
        return false;
    }

    @Override
    public boolean method_25400(class_11905 input) {
        if (super.method_25400(input)) {
            // The if statement ensures that only valid characters will trigger
            // the suggestions box.
            setSuggestorActive(true);
            suggestor.method_23934();
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean result = suggestor.method_23922(click)
                || super.method_25402(click, doubled);
        suggestor.method_23933(false);
        return result;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return suggestor.method_23921(verticalAmount)
                || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public void method_25365(boolean focused) {
        method_25395(commandField);
        commandField.method_25365(focused);
        suggestor.method_23933(false);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        renderLineNumber(context);
        if (isLoaded()) {
            renderCommandField(context, mouseX, mouseY, delta);
        } else {
            context.method_51439(textRenderer, class_2561.method_43471("commandBlockIDE.unloaded"), commandField.method_46426(), y + 5, 0x7FFFFFFF, false);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    protected void renderLineNumber(class_332 context) {
        String lineNumber = String.valueOf(index + 1);
        // Manually draw shadow because the existing functions don’t let you set the color.
        context.method_51433(textRenderer, lineNumber, x + 17 - textRenderer.method_1727(lineNumber), y + 5, 0x3F000000, false);
        context.method_51433(textRenderer, lineNumber, x + 16 - textRenderer.method_1727(lineNumber), y + 4, lineNumberHighlighted ? 0xFFFFFFFF : 0x7FFFFFFF, false);
    }

    protected void renderCommandField(class_332 context, int mouseX, int mouseY, float delta) {
        commandField.field_22764 = true;
        commandField.method_25394(context, mouseX, mouseY, delta);
    }

    public void renderSuggestions(class_332 context, int mouseX, int mouseY) {
        if (commandField.method_20315()) {
            suggestor.method_23923(context, mouseX, mouseY);
        }
    }

    public String getSingleLineCommand() {
        return processor.processCommand(commandField.method_1882()).method_15442();
    }

    public boolean isLoaded() {
        return loaded;
    }

    @SuppressWarnings("SameParameterValue")
    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
        this.commandField.method_1888(loaded);
    }

    public int getX() {
        return x;
    }

    public int getY() {
        return y;
    }

    public void setY(int y) {
        this.y = y;

        commandField.method_46419(y);
        suggestor.method_23934();

    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;

        commandField.method_25358(width - leftPadding - rightPadding - 20);

        suggestor.method_23934();
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        boolean changed = height != this.height;
        this.height = height;

        commandField.method_53533(height);

        suggestor.method_23934();

        if (changed) {
            onHeightChange(height);
        }
    }

    public boolean isSuggestorActive() {
        return suggestorActive;
    }

    public void setSuggestorActive(boolean suggestorActive) {
        suggestor.method_23933(suggestorActive);
        this.suggestorActive = suggestorActive;
    }

    protected void onHeightChange(int height) {
        if (heightChangedListener != null) {
            heightChangedListener.accept(height);
        }
    }

    public void setHeightChangedListener(@Nullable IntConsumer listener) {
        heightChangedListener = listener;
    }

    @Override
    public void method_37020(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, class_2561.method_43469("narration.edit_box", commandField.method_1882()));
    }

    protected static List<class_5481> highlight(ParseResults<class_2172> parse, String text, StringMapping mapping) {
        // The ranges of text in the single-line command containing each
        // argument that should be highlighted.
        List<StringRange> ranges = parse
                .getContext()
                .getLastChild()
                .getArguments()
                .values()
                .stream()
                .map(ParsedArgument::getRange)
                .toList();

        // This is the index that the command parser stopped at. Everything at
        // or after this index is a parse error.
        int mappedParseStopIndex = mapping.mapIndexOrAfter(parse.getReader().getCursor());

        List<class_5481> highlightedLines = new ArrayList<>();

        int startIndex = 0;
        while (startIndex <= text.length()) {
            // Find the end of the current line (exclusive)
            int endIndex = text.indexOf('\n', startIndex);
            if (endIndex == -1) {
                endIndex = text.length();
            }

            int start = startIndex;
            int end = endIndex;
            highlightedLines.add(visitor -> {
                charLoop:
                for (int index = start; index < end; index++) {
                    int codePoint = text.codePointAt(index);
                    // It's possible for codePointAt to return a low surrogate
                    // if we ask for the second byte of a surrogate pair.
                    if (codePoint < Character.MAX_VALUE && Character.isSurrogate((char) codePoint)) {
                        continue;
                    }

                    OptionalInt maybeMappedIndex = mapping.inverted().mapIndex(index);
                    if (maybeMappedIndex.isEmpty()) {
                        if (!visitor.accept(index, COMMENT_STYLE, codePoint)) {
                            return false;
                        }
                        continue;
                    }
                    int mappedIndex = maybeMappedIndex.getAsInt();

                    for (int rangeIndex = 0; rangeIndex < ranges.size(); rangeIndex++) {
                        var range = ranges.get(rangeIndex);
                        if (range.getStart() <= mappedIndex && mappedIndex < range.getEnd()) {
                            class_2583 style = ARGUMENT_STYLES.get(rangeIndex % ARGUMENT_STYLES.size());
                            if (!visitor.accept(index, style, codePoint)) {
                                return false;
                            }
                            continue charLoop;
                        }
                    }

                    class_2583 style = index >= mappedParseStopIndex ? ERROR_STYLE : INFO_STYLE;
                    if (!visitor.accept(index, style, codePoint)) {
                        return false;
                    }
                }
                return true;
            });

            startIndex = endIndex + 1;
        }

        return highlightedLines;
    }

    private static final List<class_2583> ARGUMENT_STYLES = Stream.of(
            class_124.field_1075,
            class_124.field_1054,
            class_124.field_1060,
            class_124.field_1076,
            class_124.field_1065
    ).map(class_2583.field_24360::method_10977).toList();

    private static final class_2583 INFO_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final class_2583 ERROR_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final class_2583 COMMENT_STYLE = class_2583.field_24360.method_10977(class_124.field_1063);
}
