package arm32x.minecraft.commandblockide.client.gui.screen;

import arm32x.minecraft.commandblockide.client.CommandChainTracer;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandBlockEditor;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2593;
import net.minecraft.class_332;
import net.minecraft.class_634;

public final class CommandBlockIDEScreen extends CommandIDEScreen<CommandBlockEditor> {
	private final Map<class_2338, CommandEditor> positionIndex = new HashMap<>();

	private final class_2593 startingBlockEntity;
	private int startingIndex = -1;

	public CommandBlockIDEScreen(class_2593 blockEntity) {
		super();
		startingBlockEntity = blockEntity;
	}

	@Override
	protected void firstInit() {
		assert field_22787 != null;
		CommandChainTracer tracer = new CommandChainTracer(field_22787.field_1687);

		Iterator<class_2338> iterator = tracer.traceBackwards(startingBlockEntity.method_11016()).iterator();
		class_2338 chainStart = startingBlockEntity.method_11016();
		while (iterator.hasNext()) {
			chainStart = iterator.next();
		}

		addEditor(getBlockEntityAt(chainStart));
		for (class_2338 position : tracer.traceForwards(chainStart)) {
			addEditor(getBlockEntityAt(position));
		}

		class_2338 pos = startingBlockEntity.method_11016();
		statusText = class_2561.method_43469("chat.coordinates", pos.method_10263(), pos.method_10264(), pos.method_10260())
			.method_27692(class_124.field_1080);

		super.firstInit();
	}

	private void addEditor(class_2593 blockEntity) {
		int index = editors.size();
		CommandBlockEditor editor = new CommandBlockEditor(this, field_22793, 8, 20 * index + 8, field_22789 - 16, 16, blockEntity, index);
		addEditor(editor);
		positionIndex.put(blockEntity.method_11016(), editor);
		if (blockEntity.equals(startingBlockEntity)) {
			startingIndex = index;
			setFocusedEditor(editor);
		} else {
			assert field_22787 != null && field_22787.field_1724 != null;
			editor.requestUpdate(field_22787.field_1724);
		}
	}

	private class_2593 getBlockEntityAt(class_2338 position) {
		assert field_22787 != null && field_22787.field_1687 != null;
		class_2586 blockEntity = field_22787.field_1687.method_8321(position);
		if (blockEntity instanceof class_2593) {
			return (class_2593)blockEntity;
		} else {
			throw new RuntimeException("No command block at position.");
		}
	}

	public void update(class_2338 position) {
		if (positionIndex.get(position) instanceof CommandBlockEditor editor) {
			editor.update();
			setLoaded(true);
			if (method_25399() == editor) {
				setFocusedEditor(editor);
			}
		}
	}

	@Override
	public void save() {
		assert field_22787 != null;
		class_634 networkHandler = field_22787.method_1562();
		assert networkHandler != null;
		editors.forEach(editor -> editor.save(networkHandler));
		super.save();
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		for (CommandEditor editor : editors) {
			editor.lineNumberHighlighted = editor.index == startingIndex;
		}
		super.method_25394(context, mouseX, mouseY, delta);
	}
}
