package arm32x.minecraft.commandblockide.client.gui.screen;

import arm32x.minecraft.commandblockide.client.gui.editor.CommandEditor;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandFunctionEditor;
import arm32x.minecraft.commandblockide.payloads.ApplyFunctionPayload;
import arm32x.minecraft.commandblockide.util.PacketSplitter;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public final class CommandFunctionIDEScreen extends CommandIDEScreen<CommandFunctionEditor> {
	private final class_2960 functionId;
	private final int startingLineCount;

	public CommandFunctionIDEScreen(class_2960 functionId, int lineCount) {
		this.functionId = functionId;
		this.startingLineCount = lineCount;
	}

	@Override
	protected void firstInit() {
		for (int index = 0; index < startingLineCount; index++) {
			CommandFunctionEditor editor = new CommandFunctionEditor(this, field_22793, 8, 20 * index + 8, field_22789 - 16, 16, index);
			if (index == 0) {
				setFocusedEditor(editor);
			}
			addEditor(editor);
		}

		statusText = class_2561.method_43470(functionId.toString()).method_27692(class_124.field_1080);

		super.firstInit();
	}

	public void update(int index, String command) {
		var editor = editors.get(index);
		editor.update(functionId, command);
		setLoaded(true);
		if (method_25399() == editor) {
			setFocusedEditor(editor);
		}
	}

	@Override
	public void save() {
		class_2540 buf = PacketByteBufs.create();
		PacketSplitter.writeHeader(buf);
		buf.method_10812(functionId);
		buf.method_10804(editors.size());
		for (CommandEditor editor : editors) {
			buf.method_10788(editor.getSingleLineCommand(), Integer.MAX_VALUE >> 2);
			if (editor instanceof CommandFunctionEditor functionEditor) {
				functionEditor.saveMultilineCommand(functionId);
			}
		}
		PacketSplitter.updateChunkCount(buf);

		PacketSplitter splitter = new PacketSplitter(buf);
		for (ByteBuf splitBuf : splitter) {
			ClientPlayNetworking.send(new ApplyFunctionPayload(splitBuf));
		}

		super.save();
	}
}
