package arm32x.minecraft.commandblockide.client.gui.screen;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.client.gui.ToolbarSeparator;
import arm32x.minecraft.commandblockide.client.gui.button.SimpleIconButton;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandEditor;
import arm32x.minecraft.commandblockide.client.storage.MultilineCommandStorage;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.lwjgl.glfw.GLFW;

@Environment(EnvType.CLIENT)
public abstract class CommandIDEScreen<E extends CommandEditor> extends class_437 implements Dirtyable {
	protected final List<E> editors = new ArrayList<>();
	protected int combinedEditorHeight = Integer.MAX_VALUE;
	private boolean initialized = false;

	private SimpleIconButton saveButton;

	private int scrollOffset = 0, maxScrollOffset = Integer.MAX_VALUE;
	public static final double SCROLL_SENSITIVITY = 50.0;

	private boolean draggingScrollbar = false;
	private double mouseYAtScrollbarDragStart = 0;
	private int scrollOffsetAtScrollbarDragStart = 0;

	protected @Nullable class_2561 statusText = null;
	private int statusTextX = 0;

	public CommandIDEScreen() {
		super(class_2561.method_43473());
	}

	@Override
	protected void method_25426() {
		statusTextX = addToolbarWidgets(List.of(
			saveButton = new SimpleIconButton(0, 0, "save", class_7919.method_47407(class_2561.method_43471("commandBlockIDE.save")), b -> save()),
			new ToolbarSeparator()
		));

		// Done button
		method_37063(class_4185.method_46430(class_5244.field_24334, b -> { save(); method_25419(); })
			.method_46433(field_22789 - 216, field_22790 - 28)
			.method_46437(100, 20)
			.method_46431());
		// Cancel button
		method_37063(class_4185.method_46430(class_5244.field_24335, b -> method_25419())
			.method_46433(field_22789 - 108, field_22790 - 28)
			.method_46437(100, 20)
			.method_46431());

		if (!initialized) {
			firstInit();
			initialized = true;
		} else {
			initAfterFirst();
		}
	}

	protected void firstInit() {
		setLoaded(false);

		// Make sure 'combinedEditorHeight' is set.
		repositionEditors();
		maxScrollOffset = Math.max(combinedEditorHeight - (field_22790 - 50), 0);
		// Make sure the scroll offset is in range.
		setScrollOffset(getScrollOffset());

		MultilineCommandStorage.load();
	}

	protected void initAfterFirst() {
		for (CommandEditor editor : editors) {
			method_25429(editor);
			editor.setWidth(field_22789 - 16);
		}

		maxScrollOffset = Math.max(combinedEditorHeight - (field_22790 - 50), 0);
		class_364 element = method_25399();
		if (element instanceof CommandEditor) {
			setFocusedEditor((CommandEditor)element);
		}
	}

	protected void addEditor(E editor) {
		editor.setHeightChangedListener(height -> {
			repositionEditors();
			setScrollOffset(Math.min(scrollOffset, combinedEditorHeight - 20));
		});
		editors.add(editor);
		method_25429(editor);
	}

	public void save() {
		MultilineCommandStorage.save();
	}

	@Override
	public boolean method_25422() { return false; }

	@Override
	public void method_25419() {
		super.method_25419();
	}

	@Override
	public boolean method_25404(class_11908 input) {
		if (handleSpecialKey(input)) {
			return true;
		} else if (method_25399() != null) {
			return method_25399().method_25404(input);
		} else {
			// Bypass the special cases for Escape and Tab added in the Screen
			// class to maintain full control over keyboard shortcuts.
			return false;
		}
	}

	private boolean handleSpecialKey(class_11908 input) {
		if (input.comp_4795() == GLFW.GLFW_KEY_ESCAPE) {
			class_364 focused = method_25399();
			if (focused == null) {
				// TODO: Warn about unsaved changes.
				method_25419();
				return true;
			}
			if (focused instanceof CommandEditor editor) {
				if (editor.isSuggestorActive()) {
					editor.setSuggestorActive(false);
					return true;
				} else {
					editor.method_25365(false);
				}
			}
			method_25395(null);
			return true;
		} else if (input.comp_4795() == GLFW.GLFW_KEY_ENTER || input.comp_4795() == GLFW.GLFW_KEY_KP_ENTER) {
			class_364 focused = method_25399();
			if (focused == null) {
				save();
				method_25419();
				return true;
			}
			if (input.method_74240() && focused instanceof CommandEditor editor) {
				if (editor.isSuggestorActive()) {
					editor.setSuggestorActive(false);
					return true;
				} else {
					editor.method_25365(false);
				}
				method_25395(null);
				return true;
			}
			return false;
		} else if (input.comp_4795() == GLFW.GLFW_KEY_UP && input.method_74240() || input.comp_4795() == GLFW.GLFW_KEY_TAB && input.method_74240() && input.method_74239()) {
			changeFocus(false);
			return true;
		} else if (input.comp_4795() == GLFW.GLFW_KEY_DOWN && input.method_74240() || input.comp_4795() == GLFW.GLFW_KEY_TAB && input.method_74240() && !input.method_74239()) {
			changeFocus(true);
			return true;
		} else if (input.comp_4795() == GLFW.GLFW_KEY_S && input.method_74240()) {
			saveButton.method_25354(class_310.method_1551().method_1483());
			save();
			return true;
		} else {
			return false;
		}
	}

	// This must be overridden because the superclass' implementation
	// short-circuits on success, which breaks text field focus.
	@Override
	public boolean method_25402(class_11909 click, boolean doubled) {
		if (click.comp_4798() > field_22789 - 4 && click.method_74245() == 0) {
			int virtualHeight = maxScrollOffset + field_22790;
			int scrollbarHeight = Math.round((float)field_22790 / virtualHeight * field_22790);
			int scrollbarPosition = Math.round((float)getScrollOffset() / field_22790 * scrollbarHeight);

			if (click.comp_4799() >= scrollbarPosition && click.comp_4799() <= scrollbarPosition + scrollbarHeight) {
				method_25398(true);
				draggingScrollbar = true;
				mouseYAtScrollbarDragStart = click.comp_4799();
				scrollOffsetAtScrollbarDragStart = getScrollOffset();
			} else if (click.comp_4799() < scrollbarPosition) {
				setScrollOffset((int)Math.round(getScrollOffset() - SCROLL_SENSITIVITY * 5));
			} else if (click.comp_4799() > scrollbarPosition + scrollbarHeight) {
				setScrollOffset((int)Math.round(getScrollOffset() + SCROLL_SENSITIVITY * 5));
			}
			return true;
		}

		class_364 focusedChild = null;
		for (class_364 child : method_25396()) {
			if (child.method_25402(click, doubled) && focusedChild == null) {
				focusedChild = child;
			}
		}
		method_25395(focusedChild);
		if (click.method_74245() == 0) {
			method_25398(true);
		}
		return true;
	}

	@Override
	public boolean method_25406(class_11909 click) {
		if (click.method_74245() == 0 && draggingScrollbar) {
			draggingScrollbar = false;
			return true;
		} else {
			return super.method_25406(click);
		}
	}

	@Override
	public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
		if (click.method_74245() == 0 && draggingScrollbar) {
			int virtualHeight = maxScrollOffset + field_22790;
			int scrollbarHeight = Math.round((float)field_22790 / virtualHeight * field_22790);
			int scrollOffsetDelta = (int)Math.round((click.comp_4799() - mouseYAtScrollbarDragStart) / scrollbarHeight * field_22790);
			setScrollOffset(scrollOffsetAtScrollbarDragStart + scrollOffsetDelta);
			return true;
		} else {
			return super.method_25403(click, offsetX, offsetY);
		}
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		for (CommandEditor editor : editors) {
			if (editor.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) return true;
		}

		if (verticalAmount != 0 && mouseY < field_22790 - 36) {
			setScrollOffset(getScrollOffset() - (int)Math.round(verticalAmount * SCROLL_SENSITIVITY));
			return true;
		}
		return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
	}

	public int getScrollOffset() {
		return scrollOffset;
	}

	public void setScrollOffset(int offset) {
		// Don't force the scroll offset to suddenly "jump" back to an in-bounds
		// value; instead, just prevent it from going further astray.
		int effectiveMaxScrollOffset = Math.max(scrollOffset, maxScrollOffset);
		scrollOffset = class_3532.method_15340(offset, 0, effectiveMaxScrollOffset);
		repositionEditors();
	}

	protected void repositionEditors() {
		int heightAccumulator = 8;
		for (CommandEditor editor : editors) {
			editor.setY(heightAccumulator - scrollOffset);
			heightAccumulator += editor.getHeight() + 4;
		}
		combinedEditorHeight = heightAccumulator - 12;
		// This potentially leaves the scroll offset at an out-of-range value
		// to avoid scrolling without the user intending to. The scroll offset
		// will be clamped when the user next scrolls.
		maxScrollOffset = Math.max(combinedEditorHeight - (field_22790 - 50), 0);
	}

	/**
	 * Adds the provided toolbar widgets to the screen in order.
	 * @param widgets The list of widgets to add.
	 * @return The X coordinate at which the next widget would have been placed.
	 */
	private int addToolbarWidgets(List<class_339> widgets) {
		int x = 8;
		for (class_339 widget : widgets) {
			widget.method_46421(x);
			widget.method_46419(field_22790 - 28);
			x += widget.method_25368() + 4;
			method_37063(widget);
		}
		return x;
	}

	private void changeFocus(boolean lookForwards) {
		class_364 element = method_25399();
		if (element == null) {
			CommandEditor editor = editors.get(0);
			setFocusedEditor(editor);
			return;
		}
		for (int index = 0; index < editors.size(); index++) {
			if (element instanceof CommandEditor && element.equals(editors.get(index))) {
				CommandEditor editor;
				do {
					index = index + (lookForwards ? 1 : -1);
					if (index < 0) {
						index = editors.size() - 1;
					} else if (index >= editors.size()) {
						index = 0;
					}
					editor = editors.get(index);
				} while (!editor.isLoaded());
				element.method_25365(false);
				setFocusedEditor(editor);
				return;
			}
		}
	}

	public void setFocusedEditor(CommandEditor editor) {
		method_25395(editor);
		editor.method_25365(true);

		// Ensure the focused editor is on-screen
		repositionEditors();
		int top = editor.getY() + scrollOffset;
		int bottom = top + editor.getHeight();
		setScrollOffset(class_3532.method_15340(getScrollOffset(), bottom - field_22790 + 36, top - 8));
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		// Avoid this.renderBackground because it's a no-op (see below).
		super.method_25420(context, mouseX, mouseY, delta);

		for (CommandEditor editor : editors) {
			editor.method_25394(context, mouseX, mouseY, delta);
		}
		for (CommandEditor editor : editors) {
			// This is done in a separate loop to ensure it's rendered on top.
			editor.renderSuggestions(context, mouseX, mouseY);
		}

		if (maxScrollOffset > 0) {
			int virtualHeight = maxScrollOffset + field_22790;
			int scrollbarHeight = Math.round((float)field_22790 / virtualHeight * field_22790);
			int scrollbarPosition = Math.round((float)getScrollOffset() / field_22790 * scrollbarHeight);
			context.method_25294(field_22789 - 3, scrollbarPosition + 1, field_22789 - 1, scrollbarPosition + scrollbarHeight - 1, 0x3FFFFFFF);
		}

		super.method_25394(context, mouseX, mouseY, delta);
		if (statusText != null) {
            int x = statusTextX + 5;
            int y = field_22790 - 22;
            int statusTextWidth = field_22793.method_27525(statusText);
            context.method_25294(x - 2, y - 2, x + statusTextWidth + 2, y + 9 + 2, 0x7F000000);
            context.method_27535(field_22793, statusText, statusTextX + 5, field_22790 - 22, 0xFFFFFFFF);
		}
	}

	@Override
	public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
		// No-op. This is a hack to prevent the background from being drawn a
		// second time from super.render.
	}

	@Override
	public boolean isDirty() {
		return editors.stream().anyMatch(Dirtyable::isDirty);
	}

	public boolean isLoaded() {
		return saveButton.field_22763;
	}

	protected void setLoaded(boolean loaded) {
		saveButton.field_22763 = loaded;
	}

	// private static final Logger LOGGER = LogManager.getLogger();
}
