package arm32x.minecraft.commandblockide.client.update;

import static arm32x.minecraft.commandblockide.client.CommandChainTracer.isCommandBlock;
import arm32x.minecraft.commandblockide.client.gui.screen.CommandBlockIDEScreen;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11352;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2593;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataCommandUpdateRequester {
	private static @Nullable DataCommandUpdateRequester INSTANCE = null;

	private final Map<class_2338, class_2593> blocksToUpdate = new HashMap<>();

	private DataCommandUpdateRequester() { }

	public static DataCommandUpdateRequester getInstance() {
		if (INSTANCE == null) {
			return INSTANCE = new DataCommandUpdateRequester();
		} else {
			return INSTANCE;
		}
	}

	public void requestUpdate(class_746 player, class_2593 blockEntity) {
		class_2338 position = blockEntity.method_11016();
		blocksToUpdate.put(position, blockEntity);

		String command = String.format("data get block %d %d %d", position.method_10263(), position.method_10264(), position.method_10260());
		player.field_3944.method_45730(command);
	}

	public boolean handleFeedback(class_310 client, class_2588 message) {
		Object[] args = message.method_11023();
		LOGGER.trace("Handling feedback for message {} with args {}.", message, args);

		@Nullable class_2338 position;
		try {
			position = new class_2338((int)args[0], (int)args[1], (int)args[2]);
		} catch (ClassCastException ex1) {
			try {
				position = new class_2338(Integer.parseInt(getStringFromText(args[0])), Integer.parseInt(getStringFromText(args[1])), Integer.parseInt(getStringFromText(args[2])));
			} catch (ClassCastException | NumberFormatException ex2) {
				LOGGER.error("Could not get block position from command feedback.");
				return false;
			}
		}
		if (!blocksToUpdate.containsKey(position)) {
			LOGGER.debug("Block {} not queued for update.", position);
			return false;
		}

		if (client.field_1687 == null) {
			LOGGER.warn("Client is outside of a world.");
			return false;
		}
		class_2680 blockState = client.field_1687.method_8320(position);
		if (!isCommandBlock(blockState)) {
			LOGGER.debug("Block {} is not a command block.", position);
			return false;
		}

		String stringifiedTag = ((class_2561)args[3]).getString();
		@Nullable class_2487 tag;
		try {
			tag = class_2522.method_67315(stringifiedTag);
		} catch (CommandSyntaxException ex) {
			LOGGER.error("Error parsing feedback from data command.", ex);
			return false;
		}

		@Nullable class_2593 blockEntity = blocksToUpdate.get(position);
		if (blockEntity == null) {
			LOGGER.debug("Block entity {} not queued for update.", position);
			return false;
		}

        try (var errorReporter = new class_8942.class_11340(blockEntity.method_71402(), LOGGER)) {
            blockEntity.method_58690(class_11352.method_71417(errorReporter, client.field_1687.method_30349(), tag));
        }
//		blockEntity.setNeedsUpdatePacket(false);
		if (client.field_1755 instanceof CommandBlockIDEScreen) {
			((CommandBlockIDEScreen)client.field_1755).update(position);
		}
		blocksToUpdate.remove(position);

		return true;
	}

	private static String getStringFromText(Object object) {
		if (object instanceof class_2561 text) {
			return text.getString();
		} else {
			return object.toString();
		}
	}

	private static final Logger LOGGER = LoggerFactory.getLogger(DataCommandUpdateRequester.class);
}
