package arm32x.minecraft.commandblockide.mixin.client;

import arm32x.minecraft.commandblockide.client.update.DataCommandUpdateRequester;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7594;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_7594.class)
public final class MessageHandlerMixin {
    @Shadow private @Final class_310 client;

    @Inject(
        method = "onGameMessage(Lnet/minecraft/text/Text;Z)V",
        at = @At("HEAD"),
        cancellable = true
    )
    public void onGameMessage(class_2561 message, boolean overlay, CallbackInfo ci) {
        if (message.method_10851() instanceof class_2588 content
            && content.method_11022().equals("commands.data.block.query"))
        {
            boolean handled = DataCommandUpdateRequester.getInstance().handleFeedback(client, content);
            if (handled) {
                ci.cancel();
            }
        }
    }
}
