/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_638;

public final class CommandChainTracer {
    private final class_638 world;

    public CommandChainTracer(class_638 world) {
        this.world = world;
    }

    public Iterable<class_2338> traceForwards(class_2338 startPosition) {
        return () -> new Forwards(startPosition);
    }

    public Iterable<class_2338> traceBackwards(class_2338 startPosition) {
        return () -> new Backwards(startPosition);
    }

    public static boolean isCommandBlock(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10525) || blockState.method_27852(class_2246.field_10263) || blockState.method_27852(class_2246.field_10395);
    }

    private final class Backwards
    implements Iterator<class_2338> {
        private class_2338 position;
        private final Set<class_2338> visited = new HashSet<class_2338>();

        private Backwards(class_2338 startPosition) {
            this.position = startPosition;
            this.visited.add(startPosition);
        }

        @Override
        public boolean hasNext() {
            class_2680 blockState = CommandChainTracer.this.world.method_8320(this.position);
            if (Stream.of(class_2246.field_10525, class_2246.field_10263, class_2246.field_10395).anyMatch(arg_0 -> ((class_2680)blockState).method_27852(arg_0))) {
                long resultCount = this.getStream(blockState).count();
                return resultCount == 1L;
            }
            return false;
        }

        @Override
        public class_2338 next() {
            class_2680 blockState = CommandChainTracer.this.world.method_8320(this.position);
            if (Stream.of(class_2246.field_10525, class_2246.field_10263, class_2246.field_10395).anyMatch(arg_0 -> ((class_2680)blockState).method_27852(arg_0))) {
                List<class_2338> results = this.getStream(blockState).toList();
                if (results.size() != 1) {
                    throw new NoSuchElementException();
                }
                this.position = results.getFirst();
                this.visited.add(this.position);
                return this.position;
            }
            throw new NoSuchElementException();
        }

        private Stream<class_2338> getStream(class_2680 blockState) {
            return Stream.of(class_2350.values()).filter(direction -> direction != blockState.method_11654((class_2769)class_2288.field_10791)).map(direction -> this.position.method_10093(direction)).filter(pos -> CommandChainTracer.isCommandBlock(CommandChainTracer.this.world.method_8320(pos)) && !this.visited.contains(pos)).filter(pos -> pos.method_10093((class_2350)CommandChainTracer.this.world.method_8320(pos).method_11654((class_2769)class_2288.field_10791)).equals((Object)this.position));
        }
    }

    private final class Forwards
    implements Iterator<class_2338> {
        private class_2338 position;
        private final Set<class_2338> visited = new HashSet<class_2338>();

        private Forwards(class_2338 startPosition) {
            this.position = startPosition;
            this.visited.add(startPosition);
        }

        @Override
        public boolean hasNext() {
            class_2680 blockState = CommandChainTracer.this.world.method_8320(this.position);
            if (CommandChainTracer.isCommandBlock(blockState)) {
                class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2288.field_10791);
                class_2338 nextPosition = this.position.method_10093(facing);
                class_2680 nextBlockState = CommandChainTracer.this.world.method_8320(nextPosition);
                return Stream.of(class_2246.field_10525, class_2246.field_10263, class_2246.field_10395).anyMatch(arg_0 -> ((class_2680)nextBlockState).method_27852(arg_0)) && !this.visited.contains(nextPosition);
            }
            return false;
        }

        @Override
        public class_2338 next() {
            class_2680 blockState = CommandChainTracer.this.world.method_8320(this.position);
            if (CommandChainTracer.isCommandBlock(blockState)) {
                class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2288.field_10791);
                class_2338 nextPosition = this.position.method_10093(facing);
                class_2680 nextBlockState = CommandChainTracer.this.world.method_8320(nextPosition);
                if (Stream.of(class_2246.field_10525, class_2246.field_10263, class_2246.field_10395).anyMatch(arg_0 -> ((class_2680)nextBlockState).method_27852(arg_0)) && !this.visited.contains(nextPosition)) {
                    this.position = nextPosition;
                    this.visited.add(this.position);
                    return this.position;
                }
            }
            throw new NoSuchElementException();
        }
    }
}

