/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.gui;

import arm32x.minecraft.commandblockide.mixin.client.EditBoxAccessor;
import arm32x.minecraft.commandblockide.mixin.client.TextFieldWidgetAccessor;
import arm32x.minecraft.commandblockide.util.OrderedTexts;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MultilineTextFieldWidget
extends class_342 {
    private final TextFieldWidgetAccessor self = (TextFieldWidgetAccessor)((Object)this);
    private static final int INDENT_SIZE = 4;
    private static final long CURSOR_BLINK_INTERVAL_MS = 300L;
    private final class_7530 editBox;
    private boolean horizontalScrollEnabled;
    private int horizontalScroll = 0;
    private boolean verticalScrollEnabled;
    private int verticalScroll = 0;
    public static final double SCROLL_SENSITIVITY = 15.0;
    private int lineHeight = 12;
    private SyntaxHighlighter syntaxHighlighter = SyntaxHighlighter.NONE;
    @Nullable
    private Runnable cursorChangeListener = null;
    private static final Logger logger = LogManager.getLogger();

    public MultilineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text, boolean horizontalScrollEnabled, boolean verticalScrollEnabled) {
        super(textRenderer, x, y, width, height, text);
        this.horizontalScrollEnabled = horizontalScrollEnabled;
        this.verticalScrollEnabled = verticalScrollEnabled;
        this.editBox = new class_7530(textRenderer, Integer.MAX_VALUE);
    }

    public MultilineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        this(textRenderer, x, y, width, height, text, true, true);
        this.editBox.method_44413(() -> {
            this.scrollToEnsureCursorVisible();
            if (this.cursorChangeListener != null) {
                this.cursorChangeListener.run();
            }
        });
    }

    public void method_1863(@Nullable Consumer<String> changedListener) {
        this.editBox.method_44415(Objects.requireNonNullElseGet(changedListener, () -> text -> {}));
    }

    public void setCursorChangeListener(@Nullable Runnable cursorChangeListener) {
        this.cursorChangeListener = cursorChangeListener;
    }

    public void method_1852(String text) {
        this.editBox.method_72235(text);
    }

    public String method_1882() {
        return this.editBox.method_44421();
    }

    public String method_1866() {
        return this.editBox.method_44436();
    }

    public void method_1890(Predicate<String> textPredicate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void method_73210(class_342.class_11734 formatter) {
    }

    public SyntaxHighlighter getSyntaxHighlighter() {
        return this.syntaxHighlighter;
    }

    public void setSyntaxHighlighter(SyntaxHighlighter syntaxHighlighter) {
        this.syntaxHighlighter = syntaxHighlighter;
    }

    public void method_1867(String text) {
        this.editBox.method_44420(text);
    }

    public void method_1877(int wordOffset) {
        throw new UnsupportedOperationException();
    }

    public void method_1878(int characterOffset) {
        this.editBox.method_44419(characterOffset);
    }

    public int method_1853(int wordOffset) {
        throw new UnsupportedOperationException();
    }

    public void method_1855(int offset, boolean hasShiftDown) {
        this.editBox.method_44417(hasShiftDown);
        this.editBox.method_44412(class_7533.field_39536, offset);
    }

    private void moveCursor(double mouseX, double mouseY, boolean hasShiftDown) {
        double virtualX = mouseX - (double)this.getInnerX() + (double)this.getHorizontalScroll();
        double virtualY = mouseY - (double)this.getInnerY() + (double)this.getVerticalScroll();
        int lineIndex = class_3532.method_15357((double)(virtualY / (double)this.getLineHeight()));
        class_7530.class_7531 lineSubstring = this.editBox.method_44422(lineIndex);
        String line = this.method_1882().substring(lineSubstring.comp_862(), lineSubstring.comp_863());
        int charIndexInLine = this.self.getTextRenderer().method_27523(line, class_3532.method_15357((double)virtualX)).length();
        int charIndex = lineSubstring.comp_862() + charIndexInLine;
        double leftCharacterXDistance = Math.abs((double)this.getCharacterVirtualX(charIndex) - virtualX);
        double rightCharacterXDistance = Math.abs((double)this.getCharacterVirtualX(charIndex + 1) - virtualX);
        if (rightCharacterXDistance < leftCharacterXDistance) {
            ++charIndex;
        }
        this.method_1883(charIndex, hasShiftDown);
    }

    public void method_1883(int cursor, boolean hasShiftDown) {
        this.editBox.method_44417(hasShiftDown);
        this.editBox.method_44412(class_7533.field_39535, cursor);
    }

    public void method_1875(int cursor) {
        this.method_1883(cursor, true);
    }

    public void method_1884(int index) {
        ((EditBoxAccessor)this.editBox).setSelectionEnd(index);
    }

    public boolean method_25404(class_11908 input) {
        if (input.comp_4795() == 258) {
            if (this.editBox.method_44435()) {
                logger.warn("Indenting selected lines is not yet supported");
            } else {
                int cursorLeft = this.method_1881() - this.getLineStartBefore(this.method_1881());
                String indent = " ".repeat(4 - cursorLeft % 4);
                this.editBox.method_44420(indent);
            }
            return true;
        }
        return this.editBox.method_44428(input);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (!this.method_1885()) {
            return false;
        }
        if (this.self.isFocusUnlocked()) {
            this.method_25365(this.method_25405(click.comp_4798(), click.comp_4799()));
        }
        if (this.method_25370() && this.method_25405(click.comp_4798(), click.comp_4799()) && click.method_74245() == 0) {
            this.moveCursor(click.comp_4798(), click.comp_4799(), click.method_74239());
            return true;
        }
        return false;
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (!this.method_1885()) {
            return false;
        }
        if (this.self.isFocusUnlocked()) {
            this.method_25365(this.method_25405(click.comp_4798(), click.comp_4799()));
        }
        if (this.method_25370() && this.method_25405(click.comp_4798(), click.comp_4799()) && click.method_74245() == 0) {
            this.moveCursor(click.comp_4798(), click.comp_4799(), true);
            this.editBox.method_44417(click.method_74239());
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.method_25405(mouseX, mouseY)) {
            boolean changed = this.setHorizontalScroll(this.getHorizontalScroll() - (int)Math.round(horizontalAmount * 15.0));
            boolean bl = changed = changed || this.setVerticalScroll(this.getVerticalScroll() - (int)Math.round(verticalAmount * 15.0));
            if (this.cursorChangeListener != null) {
                this.cursorChangeListener.run();
            }
            return changed;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.method_1885()) {
            return;
        }
        if (this.method_1851()) {
            class_2960 textureId = TextFieldWidgetAccessor.getTextures().method_52729(this.method_37303(), this.method_25370());
            context.method_52706(class_10799.field_56883, textureId, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }
        context.method_44379(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.method_25368() - 1, this.method_46427() + this.method_25364() - 1);
        int textColor = this.self.invokeIsEditable() ? this.self.getEditableColor() : this.self.getUneditableColor();
        int x = this.getInnerX() - this.horizontalScroll;
        int y = this.getInnerY() - this.verticalScroll;
        long timeSinceLastSwitchFocusMs = class_156.method_658() - this.self.getLastSwitchFocusTime();
        boolean showCursor = this.method_25370() && timeSinceLastSwitchFocusMs / 300L % 2L == 0L;
        boolean lineCursor = this.method_1881() < this.method_1882().length() || this.method_1882().length() >= this.self.invokeGetMaxLength();
        int cursorLine = this.getCurrentLineIndex();
        int cursorY = y + this.lineHeight * cursorLine;
        List<class_5481> lines = this.getSyntaxHighlighter().highlight(this.method_1882());
        for (int index = 0; index < lines.size(); ++index) {
            class_5481 line = lines.get(index);
            context.method_35720(this.self.getTextRenderer(), line, x, y + this.lineHeight * index, textColor);
        }
        if (showCursor) {
            int indexOfLastNewlineBeforeCursor = this.getLineStartBefore(this.method_1881()) - 1;
            int codePointsBeforeCursor = indexOfLastNewlineBeforeCursor != -1 ? this.method_1882().codePointCount(indexOfLastNewlineBeforeCursor, Math.max(this.method_1881() - 1, 0)) : this.method_1882().codePointCount(0, this.method_1881());
            class_5481 textBeforeCursor = OrderedTexts.limit(codePointsBeforeCursor, lines.get(cursorLine));
            int cursorX = x + this.self.getTextRenderer().method_30880(textBeforeCursor) - 1;
            if (lineCursor) {
                context.method_25294(cursorX, cursorY - 1, cursorX + 1, cursorY + 10, -3092272);
            } else {
                context.method_25303(this.self.getTextRenderer(), "_", cursorX + 1, cursorY, textColor);
            }
        }
        if (this.method_25370() && this.editBox.method_44435()) {
            this.renderSelection(context, x, y);
        }
        context.method_44380();
        if (this.method_49606()) {
            context.method_74037(class_11876.field_62453);
        }
    }

    private void renderSelection(class_332 context, int x, int y) {
        class_7530.class_7531 selection = this.editBox.method_44427();
        int normalizedSelectionStart = selection.comp_862();
        int normalizedSelectionEnd = selection.comp_863();
        int startX = x + this.self.getTextRenderer().method_1727(this.method_1882().substring(this.getLineStartBefore(normalizedSelectionStart), normalizedSelectionStart)) - 1;
        int startY = y + this.lineHeight * this.getLineIndex(normalizedSelectionStart) - 1;
        int endX = x + this.self.getTextRenderer().method_1727(this.method_1882().substring(this.getLineStartBefore(normalizedSelectionEnd), normalizedSelectionEnd)) - 1;
        int endY = y + this.lineHeight * this.getLineIndex(normalizedSelectionEnd) - 1;
        int leftEdge = this.getInnerX() - 1;
        int rightEdge = this.getInnerX() + this.method_1859() + 1;
        if (startY == endY) {
            context.method_72238(startX, startY, endX, endY + this.lineHeight - 1);
        } else {
            context.method_72238(startX, startY, rightEdge, startY + this.lineHeight);
            if (startY - this.lineHeight != endY && endY - this.lineHeight != startY) {
                context.method_72238(leftEdge, startY + this.lineHeight, rightEdge, endY);
            }
            context.method_72238(leftEdge, endY, endX, endY + this.lineHeight - 1);
        }
    }

    public void method_1880(int maxLength) {
        this.editBox.method_44411(maxLength);
    }

    public int method_1881() {
        return this.editBox.method_44424();
    }

    public int getLineCount() {
        return this.editBox.method_44430();
    }

    public int getCurrentLineIndex() {
        return this.getLineIndex(this.method_1881());
    }

    private int getLineIndex(int charIndex) {
        return (int)this.method_1882().substring(0, charIndex).codePoints().filter(point -> point == 10).count();
    }

    private int getLineStartBefore(int charIndex) {
        return this.method_1882().lastIndexOf(10, Math.max(charIndex, 0) - 1) + 1;
    }

    public boolean isBeforeFirstNonWhitespaceCharacterInLine(int charIndex) {
        return this.method_1882().substring(this.getLineStartBefore(charIndex), charIndex).chars().allMatch(Character::isWhitespace);
    }

    public String getLine(int lineIndex) {
        class_7530.class_7531 line = this.editBox.method_44422(lineIndex);
        return this.method_1882().substring(line.comp_862(), line.comp_863());
    }

    protected int getHorizontalScroll() {
        return this.horizontalScroll;
    }

    protected int getMaxHorizontalScroll() {
        return Math.max(0, Arrays.stream(this.method_1882().split("\n")).mapToInt(arg_0 -> ((class_327)this.self.getTextRenderer()).method_1727(arg_0)).max().orElse(0) + 8 - this.field_22758);
    }

    protected boolean setHorizontalScroll(int horizontalScroll) {
        int previous = this.horizontalScroll;
        this.horizontalScroll = class_3532.method_15340((int)horizontalScroll, (int)0, (int)this.getMaxHorizontalScroll());
        return this.horizontalScroll != previous;
    }

    protected int getVerticalScroll() {
        return this.verticalScroll;
    }

    protected int getMaxVerticalScroll() {
        return Math.max(0, this.getLineCount() * this.getLineHeight() + 2 - this.field_22759);
    }

    protected boolean setVerticalScroll(int verticalScroll) {
        int previous = this.verticalScroll;
        this.verticalScroll = class_3532.method_15340((int)verticalScroll, (int)0, (int)this.getMaxVerticalScroll());
        return this.verticalScroll != previous;
    }

    public boolean isHorizontalScrollEnabled() {
        return this.horizontalScrollEnabled;
    }

    public void setHorizontalScrollEnabled(boolean enabled) {
        this.horizontalScrollEnabled = enabled;
        this.horizontalScroll = 0;
    }

    public boolean isVerticalScrollEnabled() {
        return this.verticalScrollEnabled;
    }

    public void setVerticalScrollEnabled(boolean enabled) {
        this.verticalScrollEnabled = enabled;
        this.verticalScroll = 0;
    }

    protected void scrollToEnsureCursorVisible() {
        int virtualX = this.getCharacterVirtualX(this.method_1881());
        int virtualY = this.getCharacterVirtualY(this.method_1881());
        this.setHorizontalScroll(class_3532.method_15340((int)this.horizontalScroll, (int)(virtualX - this.method_1859()), (int)virtualX));
        this.setVerticalScroll(class_3532.method_15340((int)this.verticalScroll, (int)(virtualY - this.getInnerHeight()), (int)virtualY));
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    public int getCharacterVirtualX(int charIndex) {
        if (charIndex > this.method_1882().length()) {
            return 0;
        }
        String line = this.getLine(this.getLineIndex(charIndex));
        int indexInLine = charIndex - this.getLineStartBefore(charIndex);
        if (indexInLine > line.length()) {
            indexInLine = line.length();
        }
        return this.self.getTextRenderer().method_1727(line.substring(0, indexInLine));
    }

    public int getCharacterRealX(int charIndex) {
        return this.getInnerX() - this.horizontalScroll + this.getCharacterVirtualX(charIndex);
    }

    @Deprecated
    public int method_1889(int charIndex) {
        if (charIndex == 0) {
            return this.getInnerX();
        }
        return Math.max(this.getCharacterRealX(charIndex), this.getInnerX());
    }

    public int getCharacterVirtualY(int charIndex) {
        if (charIndex > this.method_1882().length()) {
            charIndex = this.method_1882().length();
        }
        int lineIndex = this.getLineIndex(charIndex);
        return lineIndex * this.getLineHeight();
    }

    public int getCharacterRealY(int charIndex) {
        return this.getInnerY() - this.verticalScroll + this.getCharacterVirtualY(charIndex);
    }

    private int getInnerX() {
        return this.method_46426() + (this.method_1851() ? 4 : 0);
    }

    private int getInnerY() {
        return this.method_46427() + (this.method_1851() ? 4 : 0);
    }

    private int getInnerHeight() {
        return this.method_1851() ? this.field_22759 - 6 : this.field_22759;
    }

    @FunctionalInterface
    public static interface SyntaxHighlighter {
        public static final SyntaxHighlighter NONE = text -> Arrays.stream(text.split("\n")).map(line -> class_5481.method_30747((String)line, (class_2583)class_2583.field_24360)).toList();

        public List<class_5481> highlight(String var1);
    }
}

