/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.gui.editor;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.client.gui.button.CommandBlockAutoButton;
import arm32x.minecraft.commandblockide.client.gui.button.CommandBlockTrackOutputButton;
import arm32x.minecraft.commandblockide.client.gui.button.CommandBlockTypeButton;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandEditor;
import arm32x.minecraft.commandblockide.client.storage.MultilineCommandStorage;
import arm32x.minecraft.commandblockide.client.update.DataCommandUpdateRequester;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1918;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2593;
import net.minecraft.class_2596;
import net.minecraft.class_2870;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;

public final class CommandBlockEditor
extends CommandEditor {
    private final class_2593 blockEntity;
    private final class_342 lastOutputField;
    private final CommandBlockTypeButton typeButton;
    private final CommandBlockAutoButton autoButton;
    private final CommandBlockTrackOutputButton trackOutputButton;
    private boolean commandFieldDirty = false;

    public CommandBlockEditor(class_437 screen, class_327 textRenderer, int x, int y, int width, int height, class_2593 blockEntity, int index) {
        super(screen, textRenderer, x, y, width, height, 40, 20, index);
        this.blockEntity = blockEntity;
        this.commandField.method_1880(32500);
        this.lastOutputField = new class_342(textRenderer, this.commandField.method_46426(), this.commandField.method_46427(), this.commandField.method_25368(), this.commandField.method_25364(), (class_2561)class_2561.method_43471((String)"advMode.previousOutput").method_10852((class_2561)class_2561.method_43469((String)"commandBlockIDE.narrator.editorIndex", (Object[])new Object[]{index + 1})));
        this.lastOutputField.method_1888(false);
        this.lastOutputField.method_1880(32500);
        this.lastOutputField.method_1852(class_2561.method_43471((String)"commandBlockIDE.unloaded").getString());
        this.lastOutputField.field_22764 = false;
        this.typeButton = this.addDrawableChild(new CommandBlockTypeButton(x + 20, y));
        this.typeButton.setBlockType(blockEntity.method_11039());
        this.typeButton.field_22763 = false;
        this.autoButton = this.addDrawableChild(new CommandBlockAutoButton(x + 40, y));
        this.autoButton.setAuto(this.typeButton.getBlockType() == class_2593.class_2594.field_11922);
        this.autoButton.field_22763 = false;
        this.trackOutputButton = this.addDrawableChild(new CommandBlockTrackOutputButton(x + width - 16, y));
        this.trackOutputButton.setTrackingOutput(true);
        this.trackOutputButton.field_22763 = false;
    }

    public void save(class_634 networkHandler) {
        if (this.isLoaded() && this.isDirty()) {
            class_1918 executor = this.blockEntity.method_11040();
            networkHandler.method_52787((class_2596)new class_2870(class_2338.method_49638((class_2374)executor.method_8300()), this.getSingleLineCommand(), this.typeButton.getBlockType(), this.trackOutputButton.isTrackingOutput(), this.typeButton.isConditional(), this.autoButton.isAuto()));
            executor.method_8287(this.trackOutputButton.isTrackingOutput());
            if (!this.trackOutputButton.isTrackingOutput()) {
                executor.method_8291(null);
            }
            this.saveMultilineCommand();
        }
    }

    private void saveMultilineCommand() {
        class_310 client = class_310.method_1551();
        String world = client.method_1542() ? Objects.requireNonNull(client.method_1576()).method_27728().method_150() : Objects.requireNonNull(client.method_1558()).field_3752;
        MultilineCommandStorage.getInstance().add(this.commandField.method_1882(), this.getSingleLineCommand(), client.method_1542(), world, this.blockEntity.method_11016());
    }

    public void update() {
        class_1918 executor = this.blockEntity.method_11040();
        class_310 client = class_310.method_1551();
        this.commandField.method_1852(MultilineCommandStorage.getInstance().getRobust(executor.method_8289(), this.processor, client.method_1542(), client.method_1542() ? Objects.requireNonNull(client.method_1576()).method_27728().method_150() : Objects.requireNonNull(client.method_1558()).field_3752, class_2338.method_49638((class_2374)executor.method_8300())));
        this.typeButton.setBlockType(this.blockEntity.method_11039());
        this.typeButton.setConditional(this.blockEntity.method_11046());
        this.autoButton.setAuto(this.blockEntity.method_11042());
        this.trackOutputButton.setTrackingOutput(executor.method_8296());
        String lastOutput = executor.method_8292().getString();
        if (lastOutput.isEmpty()) {
            lastOutput = class_2561.method_43471((String)"commandBlockIDE.lastOutput.none").getString();
        }
        this.lastOutputField.method_1852(lastOutput);
        this.suggestor.method_23933(this.commandField.method_20315());
        this.suggestor.method_23934();
        this.commandFieldDirty = false;
        this.setLoaded(true);
    }

    public void requestUpdate(class_746 player) {
        DataCommandUpdateRequester.getInstance().requestUpdate(player, this.blockEntity);
    }

    @Override
    public void commandChanged(String newCommand) {
        if (!newCommand.equals(this.blockEntity.method_11040().method_8289())) {
            this.commandFieldDirty = true;
        }
        super.commandChanged(newCommand);
    }

    @Override
    protected void renderCommandField(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.trackOutputButton.method_25405(mouseX, mouseY)) {
            this.commandField.field_22764 = false;
            this.lastOutputField.field_22764 = true;
            this.lastOutputField.method_25394(context, mouseX, mouseY, delta);
        } else {
            this.commandField.field_22764 = true;
            this.lastOutputField.field_22764 = false;
            this.commandField.method_25394(context, mouseX, mouseY, delta);
        }
    }

    @Override
    public void setLoaded(boolean loaded) {
        super.setLoaded(loaded);
        this.typeButton.field_22763 = loaded;
        this.autoButton.field_22763 = loaded;
        this.trackOutputButton.field_22763 = loaded;
    }

    @Override
    public boolean isDirty() {
        return this.commandFieldDirty || Stream.of(this.typeButton, this.autoButton, this.trackOutputButton).anyMatch(Dirtyable::isDirty);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.lastOutputField.method_46419(this.commandField.method_46427());
        this.typeButton.method_46419(y);
        this.autoButton.method_46419(y);
        this.trackOutputButton.method_46419(y);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.lastOutputField.method_25358(this.commandField.method_25368());
        this.trackOutputButton.method_46421(this.getX() + width - 16);
    }
}

