/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.gui.screen;

import arm32x.minecraft.commandblockide.client.CommandChainTracer;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandBlockEditor;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandEditor;
import arm32x.minecraft.commandblockide.client.gui.screen.CommandIDEScreen;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2593;
import net.minecraft.class_332;
import net.minecraft.class_634;

public final class CommandBlockIDEScreen
extends CommandIDEScreen<CommandBlockEditor> {
    private final Map<class_2338, CommandEditor> positionIndex = new HashMap<class_2338, CommandEditor>();
    private final class_2593 startingBlockEntity;
    private int startingIndex = -1;

    public CommandBlockIDEScreen(class_2593 blockEntity) {
        this.startingBlockEntity = blockEntity;
    }

    @Override
    protected void firstInit() {
        assert (this.field_22787 != null);
        CommandChainTracer tracer = new CommandChainTracer(this.field_22787.field_1687);
        Iterator<class_2338> iterator = tracer.traceBackwards(this.startingBlockEntity.method_11016()).iterator();
        class_2338 chainStart = this.startingBlockEntity.method_11016();
        while (iterator.hasNext()) {
            chainStart = iterator.next();
        }
        this.addEditor(this.getBlockEntityAt(chainStart));
        for (class_2338 position : tracer.traceForwards(chainStart)) {
            this.addEditor(this.getBlockEntityAt(position));
        }
        class_2338 pos = this.startingBlockEntity.method_11016();
        this.statusText = class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1080);
        super.firstInit();
    }

    @Override
    private void addEditor(class_2593 blockEntity) {
        int index = this.editors.size();
        CommandBlockEditor editor = new CommandBlockEditor(this, this.field_22793, 8, 20 * index + 8, this.field_22789 - 16, 16, blockEntity, index);
        this.addEditor(editor);
        this.positionIndex.put(blockEntity.method_11016(), editor);
        if (blockEntity.equals(this.startingBlockEntity)) {
            this.startingIndex = index;
            this.setFocusedEditor(editor);
        } else {
            assert (this.field_22787 != null && this.field_22787.field_1724 != null);
            editor.requestUpdate(this.field_22787.field_1724);
        }
    }

    private class_2593 getBlockEntityAt(class_2338 position) {
        assert (this.field_22787 != null && this.field_22787.field_1687 != null);
        class_2586 blockEntity = this.field_22787.field_1687.method_8321(position);
        if (blockEntity instanceof class_2593) {
            return (class_2593)blockEntity;
        }
        throw new RuntimeException("No command block at position.");
    }

    public void update(class_2338 position) {
        CommandEditor commandEditor = this.positionIndex.get(position);
        if (commandEditor instanceof CommandBlockEditor) {
            CommandBlockEditor editor = (CommandBlockEditor)commandEditor;
            editor.update();
            this.setLoaded(true);
            if (this.method_25399() == editor) {
                this.setFocusedEditor(editor);
            }
        }
    }

    @Override
    public void save() {
        assert (this.field_22787 != null);
        class_634 networkHandler = this.field_22787.method_1562();
        assert (networkHandler != null);
        this.editors.forEach(editor -> editor.save(networkHandler));
        super.save();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        for (CommandEditor editor : this.editors) {
            editor.lineNumberHighlighted = editor.index == this.startingIndex;
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }
}

