/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.processor;

import java.util.Map;
import java.util.NavigableMap;
import java.util.OptionalInt;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public final class StringMapping {
    private final NavigableMap<Integer, Integer> indexMap;
    @Nullable
    private StringMapping inverted = null;

    public StringMapping(NavigableMap<Integer, Integer> indexMap) {
        this.indexMap = indexMap;
    }

    public OptionalInt mapIndex(int index) {
        Map.Entry<Integer, Integer> entry = this.indexMap.floorEntry(index);
        int mapped = entry != null ? entry.getValue() - entry.getKey() + index : index;
        Map.Entry<Integer, Integer> nextEntry = this.indexMap.higherEntry(index);
        if (nextEntry != null && mapped >= nextEntry.getValue() && index < nextEntry.getKey()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(mapped);
    }

    public int mapIndexOrAfter(int index) {
        OptionalInt mapped;
        while ((mapped = this.mapIndex(index++)).isEmpty()) {
        }
        return mapped.getAsInt();
    }

    public static int mapIndexOrAfter(@Nullable StringMapping mapping, boolean inverted, int index) {
        if (mapping != null) {
            if (inverted) {
                return mapping.inverted().mapIndexOrAfter(index);
            }
            return mapping.mapIndexOrAfter(index);
        }
        return index;
    }

    public NavigableMap<Integer, Integer> getIndexMap() {
        return this.indexMap;
    }

    public StringMapping inverted() {
        if (this.inverted == null) {
            TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
            for (Map.Entry entry : this.indexMap.entrySet()) {
                map.put((Integer)entry.getValue(), (Integer)entry.getKey());
            }
            this.inverted = new StringMapping(map);
        }
        return this.inverted;
    }
}

