/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.storage;

import arm32x.minecraft.commandblockide.client.CommandBlockIDEClient;
import arm32x.minecraft.commandblockide.client.processor.CommandProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

@Environment(value=EnvType.CLIENT)
public final class MultilineCommandStorage
implements Serializable {
    @Nullable
    private static MultilineCommandStorage instance = null;
    private final Map<ByteBuffer, String> commands = new HashMap<ByteBuffer, String>();
    private final Map<CommandBlockLocation, byte[]> blocks = new HashMap<CommandBlockLocation, byte[]>();
    private final Map<CommandFunctionLocation, byte[]> functions = new HashMap<CommandFunctionLocation, byte[]>();

    public static MultilineCommandStorage getInstance() {
        if (instance == null) {
            instance = new MultilineCommandStorage();
        }
        return instance;
    }

    private MultilineCommandStorage() {
    }

    public void add(String multiline, String singleLine, boolean isSingleplayer, String world, class_2338 pos) {
        if (!singleLine.isBlank()) {
            byte[] singleLineHash = MultilineCommandStorage.hash(singleLine);
            this.commands.put(ByteBuffer.wrap(singleLineHash), multiline);
            this.blocks.put(new CommandBlockLocation(isSingleplayer, world, pos), singleLineHash);
        }
    }

    public void add(String multiline, String singleLine, boolean isSingleplayer, String world, class_2960 function, int lineIndex) {
        if (!singleLine.isBlank()) {
            byte[] singleLineHash = MultilineCommandStorage.hash(singleLine);
            this.commands.put(ByteBuffer.wrap(singleLineHash), multiline);
            this.functions.put(new CommandFunctionLocation(isSingleplayer, world, function, lineIndex), singleLineHash);
        }
    }

    public Optional<String> get(byte[] singleLineHash) {
        return Optional.ofNullable(this.commands.get(ByteBuffer.wrap(singleLineHash)));
    }

    public Optional<String> get(boolean isSingleplayer, String world, class_2338 pos) {
        Optional<byte[]> singleLineHash = Optional.ofNullable(this.blocks.get(new CommandBlockLocation(isSingleplayer, world, pos)));
        return singleLineHash.map(h -> this.commands.get(ByteBuffer.wrap(h)));
    }

    public Optional<String> get(boolean isSingleplayer, String world, class_2960 function, int lineIndex) {
        Optional<byte[]> singleLineHash = Optional.ofNullable(this.functions.get(new CommandFunctionLocation(isSingleplayer, world, function, lineIndex)));
        return singleLineHash.map(h -> this.commands.get(ByteBuffer.wrap(h)));
    }

    public String getRobust(String singleLine, CommandProcessor processor, boolean isSingleplayer, String world, class_2338 pos) {
        return this.getRobust(singleLine, processor, () -> this.get(isSingleplayer, world, pos));
    }

    public String getRobust(String singleLine, CommandProcessor processor, boolean isSingleplayer, String world, class_2960 function, int lineIndex) {
        return this.getRobust(singleLine, processor, () -> this.get(isSingleplayer, world, function, lineIndex));
    }

    private String getRobust(String singleLine, CommandProcessor processor, Supplier<Optional<String>> fallbackSource) {
        byte[] singleLineHash = MultilineCommandStorage.hash(singleLine);
        Optional<String> multiline = this.get(singleLineHash);
        if (multiline.isPresent()) {
            return multiline.get();
        }
        multiline = fallbackSource.get();
        if (multiline.isPresent() && ((String)processor.processCommand(multiline.get()).method_15442()).equals(singleLine)) {
            return multiline.get();
        }
        return singleLine;
    }

    public void remove(boolean isSingleplayer, String world, class_2338 pos) {
        CommandBlockLocation location = new CommandBlockLocation(isSingleplayer, world, pos);
        byte[] singleLineHash = this.blocks.get(location);
        this.blocks.remove(location);
        this.commands.remove(ByteBuffer.wrap(singleLineHash));
    }

    public void remove(boolean isSingleplayer, String world, class_2960 function, int lineIndex) {
        CommandFunctionLocation location = new CommandFunctionLocation(isSingleplayer, world, function, lineIndex);
        byte[] singleLineHash = this.functions.get(location);
        this.functions.remove(location);
        this.commands.remove(ByteBuffer.wrap(singleLineHash));
    }

    public static void save() {
        MultilineCommandStorage instance = MultilineCommandStorage.getInstance();
        try (MessagePacker packer = MessagePack.newDefaultPacker(new FileOutputStream(MultilineCommandStorage.getFile()));){
            byte[] hash;
            Record location;
            packer.packMapHeader(instance.commands.size());
            for (Map.Entry<ByteBuffer, String> entry : instance.commands.entrySet()) {
                byte[] hash2 = entry.getKey().array();
                packer.packBinaryHeader(hash2.length);
                packer.writePayload(hash2);
                String command = entry.getValue();
                packer.packString(command);
            }
            packer.packMapHeader(instance.blocks.size());
            for (Map.Entry<Object, Object> entry : instance.blocks.entrySet()) {
                location = (CommandBlockLocation)entry.getKey();
                packer.packArrayHeader(5);
                packer.packBoolean(location.isSingleplayer);
                packer.packString(location.world);
                packer.packInt(location.pos.method_10263());
                packer.packInt(location.pos.method_10264());
                packer.packInt(location.pos.method_10260());
                hash = (byte[])entry.getValue();
                packer.packBinaryHeader(hash.length);
                packer.writePayload(hash);
            }
            packer.packMapHeader(instance.functions.size());
            for (Map.Entry<Object, Object> entry : instance.functions.entrySet()) {
                location = (CommandFunctionLocation)entry.getKey();
                packer.packArrayHeader(4);
                packer.packBoolean(((CommandFunctionLocation)location).isSingleplayer);
                packer.packString(((CommandFunctionLocation)location).world);
                packer.packString(((CommandFunctionLocation)location).function.toString());
                packer.packInt(((CommandFunctionLocation)location).lineIndex);
                hash = (byte[])entry.getValue();
                packer.packBinaryHeader(hash.length);
                packer.writePayload(hash);
            }
        }
        catch (IOException ex) {
            CommandBlockIDEClient.showErrorScreen(ex, "saving multiline commands");
        }
    }

    public static void load() {
        if (!MultilineCommandStorage.getFile().exists()) {
            return;
        }
        MultilineCommandStorage instance = new MultilineCommandStorage();
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker(new FileInputStream(MultilineCommandStorage.getFile()));){
            byte[] hash;
            Record location;
            int commandsSize = unpacker.unpackMapHeader();
            for (int index = 0; index < commandsSize; ++index) {
                byte[] hash2 = unpacker.readPayload(unpacker.unpackBinaryHeader());
                String command = unpacker.unpackString();
                instance.commands.put(ByteBuffer.wrap(hash2), command);
            }
            int blocksSize = unpacker.unpackMapHeader();
            for (int index = 0; index < blocksSize; ++index) {
                int length = unpacker.unpackArrayHeader();
                if (length != 5) {
                    throw new Exception("Expected array of length 5, got length " + length);
                }
                boolean isSingleplayer = unpacker.unpackBoolean();
                String world = unpacker.unpackString();
                int x = unpacker.unpackInt();
                int y = unpacker.unpackInt();
                int z = unpacker.unpackInt();
                location = new CommandBlockLocation(isSingleplayer, world, new class_2338(x, y, z));
                hash = unpacker.readPayload(unpacker.unpackBinaryHeader());
                instance.blocks.put((CommandBlockLocation)location, hash);
            }
            int functionsSize = unpacker.unpackMapHeader();
            for (int index = 0; index < functionsSize; ++index) {
                int length = unpacker.unpackArrayHeader();
                if (length != 4) {
                    throw new Exception("Expected array of length 4, got length " + length);
                }
                boolean isSingleplayer = unpacker.unpackBoolean();
                String world = unpacker.unpackString();
                class_2960 identifier = class_2960.method_60654((String)unpacker.unpackString());
                int lineIndex = unpacker.unpackInt();
                location = new CommandFunctionLocation(isSingleplayer, world, identifier, lineIndex);
                hash = unpacker.readPayload(unpacker.unpackBinaryHeader());
                instance.functions.put((CommandFunctionLocation)location, hash);
            }
            MultilineCommandStorage.instance = instance;
        }
        catch (Exception ex) {
            CommandBlockIDEClient.showErrorScreen(ex, "loading multiline commands");
        }
    }

    private static File getFile() {
        class_310 instance = class_310.method_1551();
        return new File(instance.field_1697, "commandblockide.bin");
    }

    public static byte[] hash(String string) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private record CommandBlockLocation(boolean isSingleplayer, String world, class_2338 pos) {
    }

    private record CommandFunctionLocation(boolean isSingleplayer, String world, class_2960 function, int lineIndex) {
    }
}

