/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.server.command;

import arm32x.minecraft.commandblockide.Packets;
import arm32x.minecraft.commandblockide.payloads.EditFunctionPayload;
import arm32x.minecraft.commandblockide.payloads.UpdateFunctionCommandPayload;
import arm32x.minecraft.commandblockide.server.function.FunctionIO;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2284;
import net.minecraft.class_2561;
import net.minecraft.class_2991;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class EditFunctionCommand {
    public static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (ctx, builder) -> {
        class_2991 functionManager = ((class_2168)ctx.getSource()).method_9211().method_3740();
        return class_2172.method_9270((Iterable)functionManager.method_29463(), (SuggestionsBuilder)builder);
    };
    private static final SimpleCommandExceptionType EDIT_TAG_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"arguments.editfunction.tag.unsupported"));
    private static final SimpleCommandExceptionType MOD_NOT_INSTALLED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.editfunction.failed.modNotInstalled"));
    private static final DynamicCommandExceptionType FUNCTION_LOAD_FAILED_EXCEPTION = new DynamicCommandExceptionType(text -> (Message)text);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"editfunction").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"name", (ArgumentType)class_2284.method_9760()).suggests(SUGGESTION_PROVIDER).executes(ctx -> {
            Optional function = ((Either)class_2284.method_9768((CommandContext)ctx, (String)"name").getSecond()).left();
            if (function.isPresent()) {
                return EditFunctionCommand.execute((class_2168)ctx.getSource(), (class_2158<class_2168>)((class_2158)function.get()));
            }
            throw EDIT_TAG_EXCEPTION.create();
        })));
    }

    private static int execute(class_2168 source, class_2158<class_2168> function) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        if (player == null || !ServerPlayNetworking.canSend((class_3222)player, Packets.EDIT_FUNCTION)) {
            throw MOD_NOT_INSTALLED_EXCEPTION.create();
        }
        Either<List<String>, class_2561> loadResult = FunctionIO.loadFunction(source.method_9211(), function.comp_1994());
        if (loadResult.right().isPresent()) {
            throw FUNCTION_LOAD_FAILED_EXCEPTION.create(loadResult.right().get());
        }
        List lines = (List)loadResult.left().orElseThrow();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new EditFunctionPayload(function.comp_1994(), lines.size()));
        for (int index = 0; index < lines.size(); ++index) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new UpdateFunctionCommandPayload(index, (String)lines.get(index)));
        }
        return 1;
    }
}

