/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.server.function;

import arm32x.minecraft.commandblockide.mixin.server.DirectoryResourcePackAccessor;
import arm32x.minecraft.commandblockide.mixin.server.FunctionLoaderAccessor;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4239;
import net.minecraft.class_7654;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FunctionIO {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Either<List<String>, class_2561> loadFunction(MinecraftServer server, class_2960 functionId) {
        class_7654 resourceFinder = FunctionLoaderAccessor.getResourceFinder();
        class_2960 functionResourcePath = resourceFinder.method_45112(functionId);
        class_3300 resourceManager = server.method_34864();
        Optional functionResource = resourceManager.method_14486(functionResourcePath);
        if (functionResource.isEmpty()) {
            return Either.right((Object)class_2561.method_43469((String)"commandBlockIDE.loadFunction.failed.noResourcePack", (Object[])new Object[]{functionId}));
        }
        class_3262 pack = ((class_3298)functionResource.get()).method_45304();
        if (pack instanceof class_3258) {
            return Either.right((Object)class_2561.method_43469((String)"commandBlockIDE.loadFunction.failed.zipNotSupported", (Object[])new Object[]{functionId}).method_27692(class_124.field_1061));
        }
        if (!(pack instanceof class_3259)) {
            return Either.right((Object)class_2561.method_43469((String)"commandBlockIDE.loadFunction.failed.packClassNotSupported", (Object[])new Object[]{functionId, pack.getClass().getSimpleName()}).method_27692(class_124.field_1061));
        }
        class_3259 directoryPack = (class_3259)pack;
        DataResult<Path> pathResult = FunctionIO.getFilesystemPathOfResource(directoryPack, class_3264.field_14190, functionResourcePath);
        if (pathResult.result().isEmpty()) {
            String errorMessage = ((DataResult.Error)pathResult.error().get()).message();
            return Either.right((Object)class_2561.method_43469((String)"commandBlockIDE.loadFunction.failed.invalidPath", (Object[])new Object[]{functionId, functionResourcePath, errorMessage}));
        }
        Path path = (Path)pathResult.result().get();
        try {
            return Either.left(Files.readAllLines(path));
        }
        catch (IOException e) {
            LOGGER.error("IO exception occurred while loading function '" + functionId.toString() + "':", (Throwable)e);
            return Either.right((Object)class_2561.method_43469((String)"commandBlockIDE.loadFunction.failed.ioException", (Object[])new Object[]{functionId}).method_27692(class_124.field_1061));
        }
    }

    public static class_2561 saveFunction(MinecraftServer server, class_2960 functionId, List<String> lines) {
        class_7654 resourceFinder = FunctionLoaderAccessor.getResourceFinder();
        class_2960 functionResourcePath = resourceFinder.method_45112(functionId);
        class_3300 resourceManager = server.method_34864();
        Optional functionResource = resourceManager.method_14486(functionResourcePath);
        if (functionResource.isEmpty()) {
            return class_2561.method_43469((String)"commandBlockIDE.saveFunction.failed.noResourcePack", (Object[])new Object[]{functionId});
        }
        class_3262 pack = ((class_3298)functionResource.get()).method_45304();
        if (pack instanceof class_3258) {
            return class_2561.method_43469((String)"commandBlockIDE.saveFunction.failed.zipNotSupported", (Object[])new Object[]{functionId}).method_27692(class_124.field_1061);
        }
        if (!(pack instanceof class_3259)) {
            return class_2561.method_43469((String)"commandBlockIDE.saveFunction.failed.packClassNotSupported", (Object[])new Object[]{functionId, pack.getClass().getSimpleName()}).method_27692(class_124.field_1061);
        }
        class_3259 directoryPack = (class_3259)pack;
        DataResult<Path> pathResult = FunctionIO.getFilesystemPathOfResource(directoryPack, class_3264.field_14190, functionResourcePath);
        if (pathResult.result().isEmpty()) {
            String errorMessage = ((DataResult.Error)pathResult.error().get()).message();
            return class_2561.method_43469((String)"commandBlockIDE.saveFunction.failed.invalidPath", (Object[])new Object[]{functionId, functionResourcePath, errorMessage});
        }
        Path path = (Path)pathResult.result().get();
        try {
            Files.write(path, lines, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("IO exception occurred while saving function '" + functionId.toString() + "':", (Throwable)e);
            return class_2561.method_43469((String)"commandBlockIDE.saveFunction.failed.ioException", (Object[])new Object[]{functionId}).method_27692(class_124.field_1061);
        }
        return class_2561.method_43469((String)"commandBlockIDE.saveFunction.success.file", (Object[])new Object[]{functionId});
    }

    private static DataResult<Path> getFilesystemPathOfResource(class_3259 pack, class_3264 resourceType, class_2960 resourcePath) {
        Path root = ((DirectoryResourcePackAccessor)pack).getRoot();
        Path namespaceDir = root.resolve(resourceType.method_14413()).resolve(resourcePath.method_12836());
        return class_4239.method_46346((String)resourcePath.method_12832()).map(segments -> class_4239.method_46344((Path)namespaceDir, (List)segments));
    }
}

