/*
 * Decompiled with CFR 0.152.
 */
package com.tommustbe12.simpleranks;

import com.tommustbe12.simpleranks.RankManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class RankCommand
implements CommandExecutor {
    private final RankManager manager;

    public RankCommand(RankManager manager) {
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank create <rank>");
                    return true;
                }
                this.manager.createRank(args[1]);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Created rank: " + args[1]);
                break;
            }
            case "setdefault": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank setdefault <rank>");
                    return true;
                }
                if (!this.manager.rankExists(args[1])) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "That rank does not exist!");
                    return true;
                }
                this.manager.setDefaultRank(args[1]);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Default rank set to: " + args[1]);
                break;
            }
            case "set": {
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank set <player> <rank>");
                    return true;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                if (!this.manager.rankExists(args[2])) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "That rank does not exist!");
                    return true;
                }
                this.manager.setRank(target.getUniqueId(), args[2]);
                String coloredRank = ChatColor.translateAlternateColorCodes((char)'&', (String)args[2]) + String.valueOf(ChatColor.RESET);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s rank to " + coloredRank);
                break;
            }
            case "give": {
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank give <player> <rank>");
                    return true;
                }
                OfflinePlayer targetGive = Bukkit.getOfflinePlayer((String)args[1]);
                if (!this.manager.rankExists(args[2])) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "That rank does not exist!");
                    return true;
                }
                this.manager.setRank(targetGive.getUniqueId(), args[2]);
                String coloredRankGive = ChatColor.translateAlternateColorCodes((char)'&', (String)args[2]) + String.valueOf(ChatColor.RESET);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + targetGive.getName() + "'s rank to " + coloredRankGive);
                break;
            }
            case "list": {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Available Ranks:");
                for (String r : this.manager.getAllRanks()) {
                    String prefix = this.manager.getRankPrefix(r);
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "- " + ChatColor.translateAlternateColorCodes((char)'&', (String)prefix));
                }
                break;
            }
            case "get": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank get <player>");
                    return true;
                }
                OfflinePlayer targetGet = Bukkit.getOfflinePlayer((String)args[1]);
                String rank = this.manager.getRank(targetGet.getUniqueId());
                String prefix = this.manager.getRankPrefix(rank);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + targetGet.getName() + "'s rank: " + ChatColor.translateAlternateColorCodes((char)'&', (String)prefix));
                break;
            }
            case "delete": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank delete <rank>");
                    return true;
                }
                if (!this.manager.rankExists(args[1])) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "That rank does not exist!");
                    return true;
                }
                this.manager.deleteRank(args[1]);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Deleted rank: " + args[1]);
                break;
            }
            case "importanttext": {
                boolean important;
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rank importanttext <rank> <true|false>");
                    return true;
                }
                if (!this.manager.rankExists(args[1])) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "That rank does not exist!");
                    return true;
                }
                if (args[2].equalsIgnoreCase("true")) {
                    important = true;
                } else if (args[2].equalsIgnoreCase("false")) {
                    important = false;
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Please specify true or false for importanttext.");
                    return true;
                }
                this.manager.setImportantText(args[1], important);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set important text for rank " + args[1] + " to " + important);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "SimpleRanks Commands:");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank create <rank>");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank setdefault <rank>");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank set <player> <rank>");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank get <player>");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank list");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank delete <rank>");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/rank importanttext <rank> <true|false>");
    }
}

