/*
 * Decompiled with CFR 0.152.
 */
package com.tommustbe12.simpleranks;

import com.tommustbe12.simpleranks.Simpleranks;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;

public class RankManager {
    private final Simpleranks plugin;
    private final Map<UUID, String> playerRanks = new HashMap<UUID, String>();
    private final Map<String, RankInfo> rankData = new LinkedHashMap<String, RankInfo>();
    private String defaultRank = "default";

    public RankManager(Simpleranks plugin) {
        this.plugin = plugin;
        this.loadRanks();
    }

    private void loadRanks() {
        FileConfiguration config = this.plugin.getConfig();
        this.defaultRank = config.getString("default-rank", "default");
        this.playerRanks.clear();
        if (config.isConfigurationSection("player-ranks")) {
            for (String uuidStr : config.getConfigurationSection("player-ranks").getKeys(false)) {
                String rank = config.getString("player-ranks." + uuidStr);
                this.playerRanks.put(UUID.fromString(uuidStr), rank);
            }
        }
        this.rankData.clear();
        if (config.isConfigurationSection("ranks")) {
            for (String rankKey : config.getConfigurationSection("ranks").getKeys(false)) {
                String prefix = config.getString("ranks." + rankKey + ".prefix", "");
                boolean importantText = config.getBoolean("ranks." + rankKey + ".importantText", false);
                this.rankData.put(rankKey, new RankInfo(prefix, importantText));
            }
        }
    }

    public void saveRanks() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("player-ranks", null);
        for (Map.Entry<UUID, String> entry : this.playerRanks.entrySet()) {
            config.set("player-ranks." + entry.getKey().toString(), (Object)entry.getValue());
        }
        this.plugin.saveConfig();
    }

    public void createRank(String rank) {
        String prefix = "&7[&r" + rank + "&7]&r";
        this.plugin.getConfig().set("ranks." + rank + ".prefix", (Object)prefix);
        this.plugin.getConfig().set("ranks." + rank + ".importantText", (Object)false);
        this.plugin.saveConfig();
        this.loadRanks();
    }

    public void deleteRank(String rank) {
        this.plugin.getConfig().set("ranks." + rank, null);
        this.plugin.saveConfig();
        this.loadRanks();
    }

    public boolean rankExists(String rank) {
        return this.rankData.containsKey(rank);
    }

    public void setRank(UUID uuid, String rank) {
        this.playerRanks.put(uuid, rank);
        this.saveRanks();
    }

    public String getRank(UUID uuid) {
        return this.playerRanks.getOrDefault(uuid, this.defaultRank);
    }

    public RankInfo getRankInfo(String rank) {
        return this.rankData.getOrDefault(rank, new RankInfo("&7[Unknown]&r", false));
    }

    public RankInfo getRankInfo(UUID uuid) {
        return this.getRankInfo(this.getRank(uuid));
    }

    public void setDefaultRank(String rank) {
        this.defaultRank = rank;
        this.plugin.getConfig().set("default-rank", (Object)this.defaultRank);
        this.plugin.saveConfig();
    }

    public void setImportantText(String rank, boolean important) {
        this.plugin.getConfig().set("ranks." + rank + ".importantText", (Object)important);
        this.plugin.saveConfig();
        this.loadRanks();
    }

    public Set<String> getAllRanks() {
        return this.rankData.keySet();
    }

    public Map<UUID, String> getAllPlayerRanks() {
        return this.playerRanks;
    }

    public String getRankPrefix(String rank) {
        if (!this.rankExists(rank)) {
            return "&7[&f" + rank + "&7]&r";
        }
        return this.plugin.getConfig().getString("ranks." + rank + ".prefix", "&7[&f" + rank + "&7]&r");
    }

    public static class RankInfo {
        public final String prefix;
        public final boolean importantText;

        public RankInfo(String prefix, boolean importantText) {
            this.prefix = prefix;
            this.importantText = importantText;
        }
    }
}

