/*
 * Decompiled with CFR 0.152.
 */
package com.tommustbe12.simpleranks;

import com.tommustbe12.simpleranks.RankManager;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RankTabCompleter
implements TabCompleter {
    private final RankManager manager;

    public RankTabCompleter(RankManager manager) {
        this.manager = manager;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        if (args.length == 1) {
            List<String> subs = List.of("create", "delete", "give", "importanttext", "setdefault", "set", "get", "list");
            return subs.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": 
            case "delete": 
            case "setdefault": {
                if (args.length != 2) break;
                String partial = args[1];
                if (subCommand.equals("create")) {
                    return Collections.emptyList();
                }
                return this.manager.getAllRanks().stream().filter(rank -> rank.startsWith(partial)).sorted().collect(Collectors.toList());
            }
            case "give": 
            case "set": {
                if (args.length == 2) {
                    String partialPlayer = args[1].toLowerCase();
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialPlayer)).sorted().collect(Collectors.toList());
                }
                if (args.length != 3) break;
                String partialRank = args[2];
                return this.manager.getAllRanks().stream().filter(rank -> rank.startsWith(partialRank)).sorted().collect(Collectors.toList());
            }
            case "importanttext": {
                if (args.length == 2) {
                    String partialRank = args[1];
                    return this.manager.getAllRanks().stream().filter(rank -> rank.startsWith(partialRank)).sorted().collect(Collectors.toList());
                }
                if (args.length != 3) break;
                String partialBool = args[2].toLowerCase();
                return List.of("true", "false").stream().filter(b -> b.startsWith(partialBool)).collect(Collectors.toList());
            }
            case "get": {
                if (args.length != 2) break;
                String partialPlayer = args[1].toLowerCase();
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialPlayer)).sorted().collect(Collectors.toList());
            }
            case "list": {
                return Collections.emptyList();
            }
            default: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

