/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabricservertools.htm.config;

import com.github.fabricservertools.htm.HTM;
import com.github.fabricservertools.htm.config.SingleBlockSelector;
import com.github.fabricservertools.htm.lock.BlockFlagSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_6862;

public record HTMConfig(boolean canTrustedPlayersBreakChests, BlockFlagSet defaultFlags, List<SingleBlockSelector> autoLockingContainers) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Path.of("htm_config.json", new String[0]);
    public static final Codec<HTMConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("can_trusted_players_break_chests").forGetter(HTMConfig::canTrustedPlayersBreakChests), (App)BlockFlagSet.SAFE_CODEC.fieldOf("default_flags").forGetter(HTMConfig::defaultFlags), (App)SingleBlockSelector.CODEC.listOf().fieldOf("auto_locking_containers").forGetter(HTMConfig::autoLockingContainers)).apply((Applicative)instance, HTMConfig::new));
    public static final Codec<HTMConfig> LEGACY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canTrustedPlayersBreakChests").forGetter(HTMConfig::canTrustedPlayersBreakChests), (App)BlockFlagSet.SAFE_CODEC.fieldOf("defaultFlags").forGetter(HTMConfig::defaultFlags), (App)SingleBlockSelector.CODEC.listOf().fieldOf("autolockingContainers").forGetter(HTMConfig::autoLockingContainers)).apply((Applicative)instance, HTMConfig::new));
    public static final Codec<HTMConfig> SAFE_CODEC = Codec.withAlternative(CODEC, LEGACY_CODEC);
    private static final List<SingleBlockSelector> DEFAULT_AUTO_LOCKING_CONTAINERS = List.of(new SingleBlockSelector(class_2246.field_10034), new SingleBlockSelector(class_2246.field_10380), new SingleBlockSelector(class_2246.field_16328), new SingleBlockSelector(class_2246.field_10181), new SingleBlockSelector(class_2246.field_16333), new SingleBlockSelector(class_2246.field_16334), new SingleBlockSelector((class_6862<class_2248>)class_3481.field_21490), new SingleBlockSelector((class_6862<class_2248>)class_3481.field_61206));
    private static final HTMConfig DEFAULT_CONFIG = new HTMConfig(false, BlockFlagSet.DEFAULT, DEFAULT_AUTO_LOCKING_CONTAINERS);
    private static HTMConfig loaded = null;

    public boolean isAutoLocking(class_2680 block) {
        for (SingleBlockSelector container : this.autoLockingContainers) {
            if (!container.is(block)) continue;
            return true;
        }
        return false;
    }

    private void save() {
        try {
            Files.writeString(HTMConfig.getConfigPath(), (CharSequence)GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()), new OpenOption[0]);
        }
        catch (IOException exception) {
            HTM.LOGGER.error("Failed to save config!", (Throwable)exception);
        }
        catch (IllegalStateException exception) {
            HTM.LOGGER.error("Failed to encode config!", (Throwable)exception);
        }
    }

    public static void load() {
        if (loaded != null) {
            return;
        }
        if (!Files.exists(HTMConfig.getConfigPath(), new LinkOption[0])) {
            loaded = DEFAULT_CONFIG;
            loaded.save();
        }
        try {
            loaded = (HTMConfig)SAFE_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)Files.readString(HTMConfig.getConfigPath()))).getOrThrow();
            loaded.save();
        }
        catch (IOException | IllegalStateException exception) {
            HTM.LOGGER.error("Failed to read config, using default one!", (Throwable)exception);
            HTM.LOGGER.error("Please fix the errors above!");
            loaded = DEFAULT_CONFIG;
        }
    }

    public static HTMConfig get() {
        if (loaded == null) {
            throw new IllegalStateException("Tried to access config before it was loaded!");
        }
        return loaded;
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(CONFIG_PATH);
    }
}

