/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabricservertools.htm.interactions;

import com.github.fabricservertools.htm.HTMTexts;
import com.github.fabricservertools.htm.api.LockInteraction;
import com.github.fabricservertools.htm.api.LockableObject;
import com.github.fabricservertools.htm.lock.HTMContainerLock;
import com.mojang.authlib.GameProfile;
import eu.pb4.common.protection.api.ProtectionProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4732;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class InteractionManager
implements ProtectionProvider {
    public static final Object2ObjectMap<class_3222, LockInteraction> pendingActions = new Object2ObjectOpenHashMap();
    public static final ObjectSet<UUID> persisting = new ObjectOpenHashSet();
    public static final ObjectSet<UUID> noMessage = new ObjectOpenHashSet();
    private static final class_4732.class_3923<class_2586, LockableObject> LOCKABLE_RETRIEVER = new class_4732.class_3923<class_2586, LockableObject>(){

        public LockableObject getFromBoth(class_2586 first, class_2586 second) {
            if (first instanceof LockableObject) {
                LockableObject secondLockable;
                LockableObject lockable = (LockableObject)first;
                if (lockable.getLock().isPresent()) {
                    return lockable;
                }
                if (second instanceof LockableObject && (secondLockable = (LockableObject)second).getLock().isPresent()) {
                    return secondLockable;
                }
                return lockable;
            }
            return null;
        }

        public LockableObject getFrom(class_2586 single) {
            if (single instanceof LockableObject) {
                LockableObject lockable = (LockableObject)single;
                return lockable;
            }
            return null;
        }

        public LockableObject getFallback() {
            return null;
        }
    };
    private static final class_4732.class_3923<class_2586, LockableObject> UNLOCKED_LOCKABLE_RETRIEVER = new class_4732.class_3923<class_2586, LockableObject>(){

        public LockableObject getFromBoth(class_2586 first, class_2586 second) {
            if (first instanceof LockableObject) {
                LockableObject secondLockable;
                LockableObject lockable = (LockableObject)first;
                if (lockable.getLock().isEmpty()) {
                    return lockable;
                }
                if (second instanceof LockableObject && (secondLockable = (LockableObject)second).getLock().isEmpty()) {
                    return secondLockable;
                }
            }
            return null;
        }

        public LockableObject getFrom(class_2586 single) {
            LockableObject lockable;
            if (single instanceof LockableObject && (lockable = (LockableObject)single).getLock().isEmpty()) {
                return lockable;
            }
            return null;
        }

        public LockableObject getFallback() {
            return null;
        }
    };

    public static void execute(MinecraftServer server, class_3222 player, class_2338 pos) {
        LockInteraction action = (LockInteraction)pendingActions.get((Object)player);
        Optional<LockableObject> lockableObject = InteractionManager.getLockable(player, pos);
        lockableObject.ifPresentOrElse(object -> {
            Optional<HTMContainerLock> containerLock = object.getLock();
            if (action.requiresLock()) {
                containerLock.ifPresentOrElse(lock -> action.execute(server, player, pos, (LockableObject)object, (HTMContainerLock)lock), () -> player.method_7353(HTMTexts.NOT_LOCKED, false));
            } else {
                action.execute(server, player, pos, (LockableObject)object, containerLock.orElse(null));
            }
        }, () -> player.method_7353(HTMTexts.NOT_LOCKABLE, false));
        if (!persisting.contains((Object)player.method_5667())) {
            pendingActions.remove((Object)player);
        }
    }

    public static boolean canOpen(class_3222 player, class_2338 pos) {
        return InteractionManager.getLock(player, pos).map(lock -> lock.canOpen(player)).orElse(true);
    }

    public static Optional<HTMContainerLock> getLock(class_3222 player, class_2338 pos) {
        return InteractionManager.getLockable(player, pos).flatMap(LockableObject::getLock);
    }

    public static Optional<LockableObject> getLockable(class_3222 player, class_2338 pos) {
        return InteractionManager.getLockable(player.method_51469(), pos);
    }

    public static Optional<HTMContainerLock> getLock(class_3218 world, class_2338 pos) {
        return InteractionManager.getLockable(world, pos).flatMap(LockableObject::getLock);
    }

    public static Optional<LockableObject> getLockable(class_3218 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return Optional.empty();
        }
        return InteractionManager.getLockable(world, pos, blockEntity);
    }

    public static Optional<HTMContainerLock> getLock(class_3218 world, class_2338 pos, class_2586 blockEntity) {
        return InteractionManager.getLockable(world, pos, blockEntity).flatMap(LockableObject::getLock);
    }

    public static Optional<LockableObject> getLockable(class_3218 world, class_2338 pos, class_2586 blockEntity) {
        if (blockEntity instanceof class_2595) {
            class_2595 chest = (class_2595)blockEntity;
            class_4732.class_4734 propertySource = class_4732.method_24173((class_2591)chest.method_11017(), class_2281::method_24169, class_2281::method_9758, (class_2769)class_2281.field_10768, (class_2680)world.method_8320(pos), (class_1936)world, (class_2338)pos, (access, blockPos) -> false);
            return Optional.ofNullable((LockableObject)propertySource.apply(LOCKABLE_RETRIEVER));
        }
        if (blockEntity instanceof LockableObject) {
            LockableObject lockable = (LockableObject)blockEntity;
            return Optional.of(lockable);
        }
        return Optional.empty();
    }

    public static Optional<LockableObject> getUnlockedLockable(class_3218 world, class_2338 pos, class_2586 blockEntity) {
        LockableObject lockable;
        if (blockEntity instanceof class_2595) {
            class_2595 chest = (class_2595)blockEntity;
            class_4732.class_4734 propertySource = class_4732.method_24173((class_2591)chest.method_11017(), class_2281::method_24169, class_2281::method_9758, (class_2769)class_2281.field_10768, (class_2680)world.method_8320(pos), (class_1936)world, (class_2338)pos, (access, blockPos) -> false);
            return Optional.ofNullable((LockableObject)propertySource.apply(UNLOCKED_LOCKABLE_RETRIEVER));
        }
        if (blockEntity instanceof LockableObject && (lockable = (LockableObject)blockEntity).getLock().isEmpty()) {
            return Optional.of(lockable);
        }
        return Optional.empty();
    }

    public static void togglePersist(class_3222 player) {
        if (persisting.contains((Object)player.method_5667())) {
            persisting.remove((Object)player.method_5667());
        } else {
            persisting.add((Object)player.method_5667());
        }
    }

    public static void toggleNoMessage(class_3222 player) {
        if (noMessage.contains((Object)player.method_5667())) {
            noMessage.remove((Object)player.method_5667());
        } else {
            noMessage.add((Object)player.method_5667());
        }
    }

    public boolean isProtected(class_1937 world, class_2338 pos) {
        Optional<LockableObject> lock = InteractionManager.getLockable((class_3218)world, pos);
        return lock.isPresent();
    }

    public boolean canBreakBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        Optional<LockableObject> lockable = InteractionManager.getLockable((class_3218)world, pos);
        return lockable.flatMap(LockableObject::getLock).map(lock -> lock.owner().equals(profile.id())).orElse(true);
    }

    public boolean isAreaProtected(class_1937 world, class_238 area) {
        return false;
    }
}

