/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabricservertools.htm.lock;

import com.github.fabricservertools.htm.api.FlagType;
import com.github.fabricservertools.htm.config.HTMConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2680;

public final class FlagSet {
    public static final FlagSet DEFAULT_FLAGS = new FlagSet(Arrays.stream(FlagType.values()).collect(Collectors.toMap(Function.identity(), FlagType::defaultValue)));
    public static final FlagSet EMPTY = new FlagSet(Map.of());
    private static final Codec<Pair<FlagType, Boolean>> SINGLE_FLAG_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FlagType.CODEC.fieldOf("type").forGetter(Pair::getFirst), (App)Codec.BOOL.fieldOf("value").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    public static final Codec<FlagSet> CODEC = SINGLE_FLAG_CODEC.listOf().xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((Object)((FlagType)((Object)((Object)((Object)entry.getKey()))))), (Object)((Boolean)entry.getValue()))).toList()).xmap(FlagSet::new, set -> set.flags);
    public static final Codec<FlagSet> CONFIG_CODEC = Codec.unboundedMap(FlagType.CODEC, (Codec)Codec.BOOL).xmap(FlagSet::new, set -> set.flags);
    private final EnumMap<FlagType, Boolean> flags;

    public FlagSet(Map<FlagType, Boolean> flags) {
        this.flags = flags.isEmpty() ? new EnumMap(FlagType.class) : new EnumMap<FlagType, Boolean>(flags);
    }

    private FlagSet(EnumMap<FlagType, Boolean> flags) {
        this.flags = flags;
    }

    public boolean get(FlagType flag, class_2680 state) {
        Boolean override = this.flags.get((Object)flag);
        return override != null ? override.booleanValue() : HTMConfig.get().defaultFlags().get(flag, state);
    }

    public Boolean getNoFallback(FlagType flag) {
        return this.flags.get((Object)flag);
    }

    public FlagSet with(FlagType flag, boolean set) {
        if (this.flags.getOrDefault((Object)flag, !set) == set) {
            return this;
        }
        EnumMap<FlagType, Boolean> copy = new EnumMap<FlagType, Boolean>(this.flags);
        copy.put(flag, set);
        return new FlagSet(copy);
    }

    public FlagSet without(FlagType flag) {
        if (!this.flags.containsKey((Object)flag)) {
            return this;
        }
        if (this.flags.size() == 1) {
            return EMPTY;
        }
        EnumMap<FlagType, Boolean> copy = new EnumMap<FlagType, Boolean>(this.flags);
        copy.remove((Object)flag);
        return new FlagSet(copy);
    }

    public FlagSet expand() {
        EnumMap<FlagType, Boolean> copy = new EnumMap<FlagType, Boolean>(this.flags);
        for (FlagType flag : FlagType.values()) {
            copy.putIfAbsent(flag, flag.defaultValue());
        }
        return new FlagSet(copy);
    }

    public void forEach(class_2680 state, BiConsumer<FlagType, Boolean> consumer) {
        for (FlagType flag : FlagType.values()) {
            consumer.accept(flag, this.get(flag, state));
        }
    }
}

