/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabricservertools.htm.lock;

import com.github.fabricservertools.htm.HTMTexts;
import com.github.fabricservertools.htm.Utility;
import com.github.fabricservertools.htm.api.FlagType;
import com.github.fabricservertools.htm.api.Lock;
import com.github.fabricservertools.htm.lock.FlagSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4844;

public record HTMContainerLock(Lock lockData, UUID owner, Set<UUID> trusted, FlagSet flags) {
    public static final MapCodec<HTMContainerLock> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Lock.CODEC.forGetter(HTMContainerLock::lockData), (App)class_4844.field_25122.fieldOf("Owner").forGetter(HTMContainerLock::owner), (App)HTMContainerLock.setOf(class_4844.field_25122.listOf()).fieldOf("Trusted").forGetter(HTMContainerLock::trusted), (App)FlagSet.CODEC.fieldOf("Flags").forGetter(HTMContainerLock::flags)).apply((Applicative)instance, HTMContainerLock::new));
    public static final Codec<HTMContainerLock> CODEC = MAP_CODEC.codec();

    public HTMContainerLock(Lock type, class_3222 owner) {
        this(type, owner.method_5667(), Set.of(), FlagSet.EMPTY);
    }

    private static <T> Codec<Set<T>> setOf(Codec<List<T>> listCodec) {
        return listCodec.xmap(Set::copyOf, List::copyOf);
    }

    public boolean canOpen(class_3222 player) {
        if (this.lockData.canOpen(player, this)) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        player.method_7353(HTMTexts.CONTAINER_LOCKED, true);
        player.method_17356(class_3417.field_14731, class_3419.field_15245, 1.0f, 1.0f);
        return false;
    }

    public HTMContainerLock withType(Lock type) {
        return new HTMContainerLock(type, this.owner, this.trusted, this.flags);
    }

    public HTMContainerLock transfer(UUID id) {
        return new HTMContainerLock(this.lockData, id, this.trusted, this.flags);
    }

    public Optional<HTMContainerLock> withTrusted(UUID id) {
        HashSet<UUID> newTrusted = new HashSet<UUID>(this.trusted);
        boolean added = newTrusted.add(id);
        if (added) {
            return Optional.of(new HTMContainerLock(this.lockData, this.owner, Set.copyOf(newTrusted), this.flags));
        }
        return Optional.empty();
    }

    public Optional<HTMContainerLock> withoutTrusted(UUID id) {
        HashSet<UUID> newTrusted = new HashSet<UUID>(this.trusted);
        boolean removed = newTrusted.remove(id);
        if (removed) {
            return Optional.of(new HTMContainerLock(this.lockData, this.owner, Set.copyOf(newTrusted), this.flags));
        }
        return Optional.empty();
    }

    public HTMContainerLock withFlag(FlagType flag, boolean set) {
        return new HTMContainerLock(this.lockData, this.owner, this.trusted, this.flags.with(flag, set));
    }

    public HTMContainerLock withoutFlag(FlagType flag) {
        return new HTMContainerLock(this.lockData, this.owner, this.trusted, this.flags.without(flag));
    }

    public boolean isOwner(class_3222 player) {
        if (!this.owner.equals(player.method_5667())) {
            if (Permissions.check((class_1297)player, (String)"htm.admin", (int)2)) {
                Utility.sendMessage((class_1657)player, (class_2561)HTMTexts.CONTAINER_OVERRIDE.apply(Utility.getFormattedNameFromUUID(this.owner, player.method_51469().method_8503())));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isTrusted(UUID id) {
        return this.trusted.contains(id);
    }

    public boolean flag(FlagType flag, class_2680 state) {
        return this.flags.get(flag, state);
    }
}

