/*
 * Decompiled with CFR 0.152.
 */
package com.anip24.playertracker;

import com.anip24.playertracker.ModConfig;
import com.anip24.playertracker.mixin.MinecraftServerAccessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public class Tracker
implements ModInitializer {
    public static File overworldLogFile;
    public static File netherLogFile;
    public static File endLogFile;
    private static ModConfig config;
    private static File basePath;
    private static int prevDay;
    private static String worldName;
    public static List<class_1657> trackedPlayers;

    public static void RegisterPlayer(class_1657 toAdd) {
        if (!trackedPlayers.contains(toAdd)) {
            trackedPlayers.add(toAdd);
            if (Tracker.config.debugLogging) {
                System.out.println("Player is not already being tracked: " + toAdd);
            }
        }
    }

    public static void CreateFile(class_310 client) {
        try {
            String filename;
            if (client != null) {
                worldName = client.method_1542() ? ((MinecraftServerAccessor)Objects.requireNonNull(client.method_1576())).tracker_getSession().method_27005() : Objects.requireNonNull(client.method_1558()).field_3752;
            }
            if (!(overworldLogFile = new File(basePath, filename = worldName + "-overworld-log-" + LocalDate.now() + ".txt")).exists() && overworldLogFile.createNewFile()) {
                if (Tracker.config.debugLogging) {
                    System.out.println("Overworld log file created: " + filename);
                }
            } else if (Tracker.config.debugLogging) {
                System.out.println("Overworld log file with name " + filename + " already exists.");
            }
            if (!(netherLogFile = new File(basePath, filename = worldName + "-nether-log-" + LocalDate.now() + ".txt")).exists() && netherLogFile.createNewFile()) {
                if (Tracker.config.debugLogging) {
                    System.out.println("Nether log file created: " + filename);
                }
            } else if (Tracker.config.debugLogging) {
                System.out.println("Nether log file with name " + filename + " already exists.");
            }
            if (!(endLogFile = new File(basePath, filename = worldName + "-end-log-" + LocalDate.now() + ".txt")).exists() && endLogFile.createNewFile()) {
                if (Tracker.config.debugLogging) {
                    System.out.println("End log file created: " + filename);
                }
            } else if (Tracker.config.debugLogging) {
                System.out.println("End log file with name " + filename + " already exists.");
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred in creating a log file: ");
            e.printStackTrace();
        }
    }

    public static void LogPosition(class_1657 player) {
        class_5321 world;
        if (prevDay != LocalDate.now().getDayOfYear()) {
            Tracker.CreateFile(class_310.method_1551());
            prevDay = LocalDate.now().getDayOfYear();
        }
        File targetFile = (world = player.field_6002.method_27983()) == class_1937.field_25180 ? netherLogFile : (world == class_1937.field_25181 ? endLogFile : overworldLogFile);
        try {
            FileWriter myWriter = new FileWriter(targetFile, true);
            myWriter.write(String.format("%s; %s; (%s);\n", LocalTime.now().truncatedTo(ChronoUnit.SECONDS).toString(), player.method_5820(), player.method_24515().method_23854()));
            myWriter.close();
        }
        catch (IOException e) {
            System.out.println("An error occurred in logging the player position: ");
            e.printStackTrace();
        }
    }

    public static void LogPositions() {
        if (prevDay != LocalDate.now().getDayOfYear()) {
            Tracker.CreateFile(class_310.method_1551());
            prevDay = LocalDate.now().getDayOfYear();
        }
        for (class_1657 player : trackedPlayers) {
            class_5321 world = player.field_6002.method_27983();
            File targetFile = world == class_1937.field_25180 ? netherLogFile : (world == class_1937.field_25181 ? endLogFile : overworldLogFile);
            try {
                FileWriter myWriter = new FileWriter(targetFile, true);
                myWriter.write(String.format("%s; %s; (%s);\n", LocalTime.now().truncatedTo(ChronoUnit.SECONDS).toString(), player.method_5820(), player.method_24515().method_23854()));
                myWriter.close();
            }
            catch (IOException e) {
                System.out.println("An error occurred in logging the player position: " + e);
                e.printStackTrace();
            }
        }
    }

    public static ModConfig getConfig() {
        return config;
    }

    public void onInitialize() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        basePath = FabricLoader.getInstance().getGameDir().resolve("playerTracker").toFile();
        prevDay = LocalDate.now().getDayOfYear();
        File containerFolder = new File(basePath.getPath());
        if (!containerFolder.exists()) {
            boolean result = containerFolder.mkdirs();
            if (Tracker.config.debugLogging) {
                System.out.println(result ? "Successfully created" : "Failed to create the log container folder");
            }
        }
        ClientPlayConnectionEvents.JOIN.register((handler, sender, _client) -> Tracker.CreateFile(_client));
    }

    static {
        prevDay = 0;
        trackedPlayers = new ArrayList<class_1657>();
    }
}

