#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

vec4 overlayColor = texelFetch(Sampler1, texCoord1, 0);

#moj_import <minecraft:utils.glsl>

void main() {
	vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
	
	editColors(); // Add this to whatever after color is declared
	color = preColor * vertexColor * ColorModulator;
	
    if (color.a < 0.1) {
        discard;
    }
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);

	if (shouldBeEmissive()) {
		fragColor = linear_fog(preColor, vertexDistance, FogStart, FogEnd, FogColor);
	}
}
