#version 150

#moj_import <bluebird:settings.glsl>

vec2 texSize = textureSize(Sampler0,0);
vec4 preColor = texture(Sampler0, texCoord0);
vec4 preOverlayColor = overlayColor;

#moj_import <globals.glsl>

// Helper Methods

vec3 color(int r, int g, int b) {
	return vec3(r,g,b)/255.;
}

vec4 color(int r, int g, int b, int a) {
	return vec4(r,g,b,a)/255.;
}

vec4 coordColor(int x, int y) {
	return texture(Sampler0, vec2(x/texSize.x, y/texSize.y));
}

vec2 getCoord() {
	return texCoord0*texSize;
}

bool coordIs(int x, int y) {
	return (texCoord0.x > x/texSize.x && texCoord0.y > y/texSize.y) && (texCoord0.x < (x+1)/texSize.x && texCoord0.y < (y+1)/texSize.y);
}

bool colorIs(int r, int g, int b) {
	return preColor.rgb == color(r,g,b);
}

bool coordColorIs(int x, int y, int r, int g, int b) {
	return coordColor(x,y).rgb == color(r,g,b);
}

bool coordColorIs(int x, int y, vec3 color) {
	return coordColor(x,y).rgb == color;
}

bool betweenCoords(int x1, int y1, int x2, int y2) {
	if (x1>x2) {
		int temp = x1;
		x1 = x2;
		x2 = temp;
	}
	if (y1>y2){
		int temp = y1;
		y1 = y2;
		y2 = temp;
	}

	return texCoord0.x > x1/texSize.x && texCoord0.x < x2/texSize.x && texCoord0.y > y1/texSize.y && texCoord0.y < y2/texSize.y;
}

bool isCape() {
	return (texSize == vec2(64, 32) && coordColor(0,0).a == 0.0 && coordColor(8, 28).a == 0 && coordColor(4, 4).a == 1);
}

bool isOfficeCape() {
	return (isCape() && coordColorIs(0, 1, 43, 39, 45) && (
		colorIs(255, 232, 102) || colorIs(248, 137, 66) || colorIs(188, 73, 20) || colorIs(145, 62, 24))
	);
}

bool isSteveCape() {
	return (isCape() && coordColorIs(40,7,38,26,22) && coordColorIs(39,8,38,26,22) && coordColorIs(40,9,232, 150, 106));
}

bool isArmorTrim() {
	return texSize.x == 2048 && mod(texSize.y, 1024) == 0;
}

bool isExperienceCape() {
	return isCape() && coordColorIs(0,1,48,31,71) &&
	(colorIs(94, 134, 50) || colorIs(153, 43, 43));
}

bool isMovieCapePortal() {
	return isSteveCape() && (betweenCoords(4, 8, 8, 14) || betweenCoords(15, 8, 19, 14));
}

bool isTwitchCape() {
	return isCape() && coordColorIs(0,1,112,45,224) && (
	(betweenCoords(38, 14, 45, 5) && !coordIs(39, 13) && (colorIs(145, 70, 255) || colorIs(93, 22, 197) || colorIs(126, 59, 240) || colorIs(113, 46, 224))) ||
	(betweenCoords(2,5,10,12) && !coordIs(2, 5) && !coordIs(5, 5) && !coordIs(6, 5) && !coordIs(9, 5) && !coordIs(2, 9) && !coordIs(2, 10) && !coordIs(2, 11) && !coordIs(3, 10) && !coordIs(3, 11) && !coordIs(4, 11) && !coordIs(7, 11) && !coordIs(8, 10) && !coordIs(8, 11) && !coordIs(9, 9) && !coordIs(9, 10) && !coordIs(9, 11))
	);
}

bool isSlimSkin() {
	return texSize == vec2(64,64) && (coordColorIs(46, 52, 0, 0, 0) || coordColorIs(46, 52, 255, 255, 255)) && coordColor(46, 52).a == 1;
}

bool usingWideSkin() {
	return false;
}

bool skinEffects() {
	return texSize == vec2(64, 64) && coordColorIs(63, 0, 0, 192, 255);
}

bool skinBlink() {
	return coordColorIs(62, 0, 255, 0, 0) && GameTime > 0.01 && (mod(GameTime * 1200, coordColor(62,0).a*255) < 0.2);
}

bool damageColor() {
	return coordColor(61, 0).a != 0 && preOverlayColor.r > preOverlayColor.g;
}

// Main
bool shouldBeEmissive() {
	return (
	(isArmorTrim() && ARMOR_TRIMS) || 
	(isOfficeCape() && OFFICE_CAPE) || 
	(isExperienceCape() && EXPERIENCE_CAPE) ||
	(isMovieCapePortal() && MOVIE_CAPE_PORTALS) ||
	(isTwitchCape() && TWITCH_PURPLE_HEART)
	);
}

void editColors() {
	if (isSteveCape() && REMOVE_STEVE_ELYTRA) {
		vec3 fillColor = texture(Sampler0, vec2(37.0/64.0, 6.0/32.0)).rgb;
		if (preColor.rgb == vec3(38, 26, 22)/255. || preColor.rgb == vec3(49, 37, 30)/255. || preColor.rgb == vec3(68, 48, 39)/255. || preColor.rgb == vec3(232, 150, 106)/255. || preColor.rgb == vec3(243, 175, 138)/255. || preColor.rgb == vec3(255, 200, 163)/255. || preColor.rgb == vec3(81, 50, 27)/255. || preColor.rgb == vec3(89, 82, 79)/255. || preColor.rgb == vec3(169, 161, 156)/255. || preColor.rgb == vec3(138, 127, 120)/255. || preColor.rgb == vec3(74, 63, 58)/255. || preColor.rgb == vec3(115, 104, 101)/255. || preColor.rgb == vec3(159, 151, 146)/255. || preColor.rgb == vec3(1.0) || preColor.rgb == vec3(34, 166, 212)/255. || preColor.rgb == vec3(0, 132, 161)/255. || preColor.rgb == vec3(71, 200, 253)/255. || preColor.rgb == vec3(68, 209, 240)/255.) {
			preColor.rgb = fillColor.rgb;
		}
	}
}