/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.artifact.ArtifactRegistry;
import xyz.phanta.tconevo.handler.ArtifactLootHandler;
import xyz.phanta.tconevo.handler.EnergizedTraitConflictHandler;
import xyz.phanta.tconevo.handler.EnergyShieldHandler;
import xyz.phanta.tconevo.handler.EntityAttributeHandler;
import xyz.phanta.tconevo.handler.FlightSpeedHandler;
import xyz.phanta.tconevo.handler.MaterialOverrideHandler;
import xyz.phanta.tconevo.handler.PlayerStateHandler;
import xyz.phanta.tconevo.handler.ToolCapabilityHandler;
import xyz.phanta.tconevo.handler.ToolCraftingHandler;
import xyz.phanta.tconevo.init.TconEvoItems;
import xyz.phanta.tconevo.init.TconEvoTraits;
import xyz.phanta.tconevo.integration.IntegrationManager;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;
import xyz.phanta.tconevo.material.MaterialDefinition;
import xyz.phanta.tconevo.network.CPacketGaiaWrath;
import xyz.phanta.tconevo.network.SPacketEntitySpecialEffect;
import xyz.phanta.tconevo.network.SPacketLightningEffect;
import xyz.phanta.tconevo.network.SPacketUpdateAppliedFlightSpeed;
import xyz.phanta.tconevo.recipe.MasterRecipes;
import xyz.phanta.tconevo.recipe.OreDictRegistration;

public class CommonProxy {
    private static final long CONFIG_VERSION = 2L;
    private static final String CONFIG_VERSION_FILE = ".config_version";
    private final ToolCapabilityHandler toolCapHandler = new ToolCapabilityHandler();
    private final PlayerStateHandler playerStateHandler = new PlayerStateHandler();
    private final ArtifactRegistry artifactRegistry = new ArtifactRegistry();

    public void onPreInit(FMLPreInitializationEvent event) {
        IntegrationManager.injectHooks(event.getAsmData());
        MinecraftForge.EVENT_BUS.register((Object)this.toolCapHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.playerStateHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ToolCraftingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EnergyShieldHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ArtifactLootHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EnergizedTraitConflictHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FlightSpeedHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityAttributeHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RegistrationHandler());
        SimpleNetworkWrapper netHandler = TconEvoMod.INSTANCE.getNetworkHandler();
        netHandler.registerMessage(SPacketEntitySpecialEffect.Handler.class, SPacketEntitySpecialEffect.class, 0, Side.CLIENT);
        netHandler.registerMessage(CPacketGaiaWrath.Handler.class, CPacketGaiaWrath.class, 1, Side.SERVER);
        netHandler.registerMessage(SPacketLightningEffect.Handler.class, SPacketLightningEffect.class, 2, Side.CLIENT);
        netHandler.registerMessage(SPacketUpdateAppliedFlightSpeed.Handler.class, SPacketUpdateAppliedFlightSpeed.class, 3, Side.CLIENT);
        IntegrationManager.dispatchPreInit(event);
        TconEvoMod.LOGGER.info("Current config version: {}", (Object)2L);
        Path configDir = event.getModConfigurationDirectory().toPath().resolve("tconevo");
        if (!Files.exists(configDir, new LinkOption[0])) {
            TconEvoMod.LOGGER.info("No config directory found; writing defaults...");
            this.writeDefaultConfig(configDir);
        } else {
            Path versionFile = configDir.resolve(CONFIG_VERSION_FILE);
            try {
                if (!Files.exists(versionFile, new LinkOption[0])) {
                    TconEvoMod.LOGGER.info("No config version file found; writing defaults...");
                    this.writeDefaultConfig(configDir);
                } else {
                    long confVer = Long.parseLong(new String(Files.readAllBytes(versionFile), StandardCharsets.UTF_8).trim());
                    if (confVer < 2L) {
                        TconEvoMod.LOGGER.info("Outdated config version {} found; writing defaults...", (Object)confVer);
                        this.writeDefaultConfig(configDir);
                    } else {
                        TconEvoMod.LOGGER.info("Config version {} found; nothing to do.", (Object)confVer);
                    }
                }
            }
            catch (Exception e) {
                TconEvoMod.LOGGER.error("Failed to read config version file!", (Throwable)e);
                TconEvoMod.LOGGER.error("Delete the file if you want to regenerate the config directory.");
                TconEvoMod.LOGGER.error("Otherwise, edit it so that it contains the number \"{}\".", (Object)2L);
            }
        }
        this.artifactRegistry.getLoader().setArtifactDir(configDir.resolve("artifacts"));
        this.artifactRegistry.getLoader().loadArtifacts();
    }

    private void writeDefaultConfig(Path destDir) {
        try {
            Files.createDirectories(destDir, new FileAttribute[0]);
            ArrayList<String> configFiles = new ArrayList<String>();
            try (BufferedReader indexIn = new BufferedReader(new InputStreamReader(Objects.requireNonNull(TconEvoMod.class.getResourceAsStream("/tconevo_config/index.txt"))));){
                String line;
                while ((line = indexIn.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    configFiles.add(line);
                }
            }
            for (String configFile : configFiles) {
                TconEvoMod.LOGGER.debug("Writing default config file: {}", (Object)configFile);
                Path destFile = destDir.resolve(configFile);
                if (Files.exists(destFile, new LinkOption[0])) continue;
                try {
                    InputStream cfgIn = Objects.requireNonNull(TconEvoMod.class.getResourceAsStream("/tconevo_config/" + configFile));
                    Throwable throwable = null;
                    try {
                        Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                        Files.copy(cfgIn, destFile, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cfgIn == null) continue;
                        if (throwable != null) {
                            try {
                                cfgIn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        cfgIn.close();
                    }
                }
                catch (IOException e) {
                    TconEvoMod.LOGGER.warn("Failed to write default config file: " + configFile, (Throwable)e);
                }
            }
            Files.write(destDir.resolve(CONFIG_VERSION_FILE), Collections.singleton(Long.toString(2L)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            TconEvoMod.LOGGER.error("Failed to write default config directory!", (Throwable)e);
        }
    }

    public void onInit(FMLInitializationEvent event) {
        TconEvoItems.registerToolForging();
        IntegrationManager.dispatchInit(event);
        MasterRecipes.initRecipes();
        MaterialDefinition.initMaterialProperties();
        TconEvoTraits.initModifierMaterials();
        ConArmHooks.INSTANCE.registerModifiers();
    }

    public void onImcReceived(FMLInterModComms.IMCEvent event) {
        MaterialDefinition.activate();
        MaterialOverrideHandler.handleTraitInheritance();
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        IntegrationManager.dispatchPostInit(event);
        MaterialOverrideHandler.handleRecipeOverrides();
        this.artifactRegistry.initArtifacts();
    }

    public ToolCapabilityHandler getToolCapHandler() {
        return this.toolCapHandler;
    }

    public PlayerStateHandler getPlayerStateHandler() {
        return this.playerStateHandler;
    }

    public ArtifactRegistry getArtifactRegistry() {
        return this.artifactRegistry;
    }

    public void playEntityEffect(Entity entity, SPacketEntitySpecialEffect.EffectType type) {
        TconEvoMod.INSTANCE.getNetworkHandler().sendToAllAround((IMessage)new SPacketEntitySpecialEffect(entity.func_145782_y(), type), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0));
    }

    public void playLightningEffect(Entity ref, List<Vec3d> positions) {
        TconEvoMod.INSTANCE.getNetworkHandler().sendToAllAround((IMessage)new SPacketLightningEffect(positions), new NetworkRegistry.TargetPoint(ref.field_71093_bK, ref.field_70165_t, ref.field_70163_u, ref.field_70161_v, 64.0));
    }

    protected static class RegistrationHandler {
        protected RegistrationHandler() {
        }

        @SubscribeEvent
        public void onRegisterPotions(RegistryEvent.Register<Potion> event) {
            OreDictRegistration.registerOreDict();
        }
    }
}

