/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo;

import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.common.config.Config;

@Config(modid="tconevo")
public class TconEvoConfig {
    @Config.Comment(value={"When enabled, Tinkers' Evolution will replace tool materials added by other mods in case overlaps occur."})
    @Config.RequiresMcRestart
    public static boolean overrideMaterials = true;
    @Config.Comment(value={"A list of material IDs for tool materials that should be disabled."})
    @Config.RequiresMcRestart
    public static String[] disabledMaterials = new String[0];
    @Config.Comment(value={"A list of material IDs to always load, regardless of other loading conditions."})
    @Config.RequiresMcRestart
    public static String[] forceLoadMaterials = new String[0];
    @Config.Comment(value={"A list of modifier IDs for modifiers that should be disabled."})
    @Config.RequiresMcRestart
    public static String[] disabledModifiers = new String[0];
    @Config.Comment(value={"A list of mod IDs for integration modules whose hook classes (i.e. special behaviour) should not be loaded.", "Note that this does not disable the materials and modifiers for that mod!", "These are handled separately by `disabledMaterials` and `disabledModifiers`."})
    @Config.RequiresMcRestart
    public static String[] disabledModHooks = new String[0];
    @Config.Comment(value={"Configuration for the mod in general."})
    public static final General general = new General();
    @Config.Comment(value={"Configuration for tools added by Tinkers' Evolution."})
    public static final Tools tools = new Tools();
    @Config.Comment(value={"Configuration for various tweaks to Tinkers' Construct and its addons."})
    public static final Tweaks tweaks = new Tweaks();
    @Config.Comment(value={"Configuration for the artifacts system."})
    public static final Artifacts artifacts = new Artifacts();
    @Config.Comment(value={"Configuration for client-side features."})
    public static final Client client = new Client();
    @Config.Comment(value={"Configuration for the Astral Sorcery module."})
    public static final AstralSorcery moduleAstralSorcery = new AstralSorcery();
    @Config.Comment(value={"Configuration for the Avaritia module."})
    public static final Avaritia moduleAvaritia = new Avaritia();
    @Config.Comment(value={"Configuration for the Blood Magic module."})
    public static final BloodMagic moduleBloodMagic = new BloodMagic();
    @Config.Comment(value={"Configuration for the Botania module.", "As a reference, a mana pool holds 1 million units of mana.", "To repair one point of durability, the manasteel pickaxe uses 60 mana and the terra shatterer uses 100."})
    public static final Botania moduleBotania = new Botania();
    @Config.Comment(value={"Configuration for the Construct's Armoury module."})
    public static final ConstructsArmoury moduleConstructsArmoury = new ConstructsArmoury();
    @Config.Comment(value={"Configuration for the Draconic Evolution module."})
    public static final DraconicEvolution moduleDraconicEvolution = new DraconicEvolution();
    @Config.Comment(value={"Configuration for the Elenai Dodge 2 module."})
    public static final ElenaiDodge moduleElenaiDodge = new ElenaiDodge();
    @Config.Comment(value={"Configuration for the Ender IO module."})
    public static final EnderIo moduleEnderIo = new EnderIo();
    @Config.Comment(value={"Configuration for the Environmental Tech module."})
    public static final EnvironmentalTech moduleEnvironmentalTech = new EnvironmentalTech();
    @Config.Comment(value={"Configuration for the Industrial Foregoing module."})
    public static final IndustrialForegoing moduleIndustrialForegoing = new IndustrialForegoing();
    @Config.Comment(value={"Configuration for the IC2 module"})
    public static final Ic2 moduleIndustrialCraft = new Ic2();
    @Config.Comment(value={"Configuration for the Natural Absorption module."})
    public static final NaturalAbsorption moduleNaturalAbsorption = new NaturalAbsorption();
    @Config.Comment(value={"Configuration for the Project: E module."})
    public static final ProjectE moduleProjectE = new ProjectE();
    @Config.Comment(value={"Configuration for the Thaumcraft module."})
    public static final Thaumcraft moduleThaumcraft = new Thaumcraft();
    @Config.Comment(value={"Configuration for the Thermal Series module."})
    public static final ThermalSeries moduleThermalSeries = new ThermalSeries();

    public static <T> T armourSwitch(EntityEquipmentSlot slot, T helmet, T chestplate, T leggings, T boots, T defaultValue) {
        switch (slot) {
            case HEAD: {
                return helmet;
            }
            case CHEST: {
                return chestplate;
            }
            case LEGS: {
                return leggings;
            }
            case FEET: {
                return boots;
            }
        }
        return defaultValue;
    }

    public static class ThermalSeries {
        @Config.Comment(value={"Allows smeltery melting recipes to be executed using a magma crucible."})
        @Config.RequiresMcRestart
        public boolean magmaCrucibleMeltingEnabled = true;
        @Config.Comment(value={"The multiplier for magma crucible melting recipe costs.", "This is multiplied by the recipe's required temperature to compute the recipe cost in RF."})
        @Config.RangeDouble(min=0.0)
        @Config.RequiresMcRestart
        public double magmaCrucibleMeltingCostMultiplier = 9.0;
        @Config.Comment(value={"The burn time, in ticks, per 50 mB of blazing pyrotheum when used as a smeltery fuel.", "Set to zero to disable blazing pyrotheum as a smeltery fuel."})
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int fuelPyrotheumBurnTime = 150;
    }

    public static class Thaumcraft {
        @Config.Comment(value={"The percentage vis discount provided per level of the aura affinity trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1, max=100)
        public int auraAffinityVisDiscount = 2;
    }

    public static class ProjectE {
        @Config.Comment(value={"The percentage of damage converted to EMC by each level of the eternal density trait.", "This is multiplied by the level of the trait to determine the final conversion ratio."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double eternalDensityDamageConversion = 16.0;
        @Config.Comment(value={"The additional damage reduction granted per piece of armour with the superdense trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double superdenseDamageReduction = 0.15;
        @Config.Comment(value={"The additional damage reduction granted per piece of armour with the ultradense trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double ultradenseDamageReduction = 0.2;
    }

    public static class NaturalAbsorption {
        @Config.Comment(value={"Causes only the first level of the absorption armour modifier to consume a modifier slot.", "Only useful with Construct's Armoury installed."})
        @Config.RequiresMcRestart
        public boolean absorptionOnlyUsesOneModifier = false;
    }

    public static class Ic2 {
        @Config.Comment(value={"The cost, in EU, per point of durability absorbed on tools with the electric trait."})
        @Config.RangeDouble(min=0.0)
        public double electricToolEnergyCost = 100.0;
        @Config.Comment(value={"The total EU that can be stored in tools with the electric trait."})
        @Config.RangeDouble(min=0.0)
        public double electricToolEnergyBuffer = 30000.0;
        @Config.Comment(value={"The divider used to calculate the maximum energy transfer rate for electric equipment.", "Transfer rate is calculated as `capacity/n`, where `n` is this config value.", "Set to zero for unlimited transfer rate."})
        @Config.RangeDouble(min=0.0)
        public double electricPowerTransferDivider = 100.0;
        @Config.Comment(value={"The power tier for equipment with the electric trait."})
        @Config.RangeInt(min=1)
        public int electricPowerTier = 1;
        @Config.Comment(value={"The cost, in EU, per point of durability absorbed on armour with the electric trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0)
        public double electricArmourEnergyCost = 400.0;
        @Config.Comment(value={"The total EU that can be stored in armour with the electric trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0)
        public double electricArmourEnergyBuffer = 30000.0;
        @Config.Comment(value={"The burn time, in ticks, per 50 mB of superheated steam when used as a smeltery fuel.", "Set to zero to disable superheated steam as a smeltery fuel."})
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int fuelSuperheatedSteamBurnTime = 12;
    }

    public static class IndustrialForegoing {
        @Config.Comment(value={"The probability of a pink slime spawning with the pink slimey trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double slimeyPinkSpawnProbability = 0.0033;
    }

    public static class EnvironmentalTech {
        @Config.Comment(value={"The divider for the solar generation rate for environmental tech solar cells.", "Since the solar gen rate is balanced around the cost of the controller, we use a divider to account for it.", "For reference, the default generation rate of a litherite cell with no divider is ~60 RF/t"})
        @Config.RangeDouble(min=1.0, max=3.4028234663852886E38)
        public double solarGenDivider = 7.5;
    }

    public static class EnderIo {
        @Config.Comment(value={"The burn time, in ticks, per 50 mB of fire water when used as a smeltery fuel.", "Set to zero to disable fire water as a smeltery fuel."})
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int fuelFireWaterBurnTime = 125;
    }

    public static class ElenaiDodge {
        @Config.Comment(value={"The duration, in ticks, of the weight effect inflicted by the grounding modifier."})
        @Config.RangeInt(min=1)
        public int groundingDuration = 20;
        @Config.Comment(value={"Causes only the first level of the weightless armour modifier to consume a modifier slot.", "Only useful with Construct's Armoury installed."})
        @Config.RequiresMcRestart
        public boolean weightlessOnlyUsesOneModifier = false;
    }

    public static class DraconicEvolution {
        @Config.Comment(value={"The base RF capacity of wyvern tools and armour."})
        @Config.RangeInt(min=1)
        public int baseRfCapacityWyvern = 4000000;
        @Config.Comment(value={"The base RF capacity of draconic tools and armour."})
        @Config.RangeInt(min=1)
        public int baseRfCapacityDraconic = 16000000;
        @Config.Comment(value={"The base RF capacity of chaotic tools and armour."})
        @Config.RangeInt(min=1)
        public int baseRfCapacityChaotic = 64000000;
        @Config.Comment(value={"The maximum RF transfer rate for wyvern tools and armour."})
        @Config.RangeInt(min=1)
        public int rfTransferWyvern = 512000;
        @Config.Comment(value={"The maximum RF transfer rate for draconic tools and armour."})
        @Config.RangeInt(min=1)
        public int rfTransferDraconic = 1000000;
        @Config.Comment(value={"The maximum RF transfer rate for chaotic tools and armour."})
        @Config.RangeInt(min=1)
        public int rfTransferChaotic = 4000000;
        @Config.Comment(value={"The energy cost per operation for wyvern tools."})
        @Config.RangeInt(min=0)
        public int operationEnergyWyvern = 1024;
        @Config.Comment(value={"The energy cost per operation for draconic tools."})
        @Config.RangeInt(min=0)
        public int operationEnergyDraconic = 1024;
        @Config.Comment(value={"The energy cost per operation for chaotic tools."})
        @Config.RangeInt(min=0)
        public int operationEnergyChaotic = 1024;
        @Config.Comment(value={"The base shield capacity for wyvern armour. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=0)
        public int baseShieldCapacityWyvern = 256;
        @Config.Comment(value={"The base shield capacity for draconic armour. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=0)
        public int baseShieldCapacityDraconic = 512;
        @Config.Comment(value={"The base shield capacity for chaotic armour. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=0)
        public int baseShieldCapacityChaotic = 1024;
        @Config.Comment(value={"The base shield recovery rate for wyvern armour. Only useful with Construct's Armoury."})
        @Config.RangeDouble(min=0.0)
        public double baseShieldRecoveryWyvern = 2.0;
        @Config.Comment(value={"The base shield recovery rate for draconic armour. Only useful with Construct's Armoury."})
        @Config.RangeDouble(min=0.0)
        public double baseShieldRecoveryDraconic = 4.0;
        @Config.Comment(value={"The base shield recovery rate for chaotic armour. Only useful with Construct's Armoury."})
        @Config.RangeDouble(min=0.0)
        public double baseShieldRecoveryChaotic = 7.0;
        @Config.Comment(value={"The energy cost per shield point for wyvern armour. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=0)
        public int shieldRecoveryEnergyWyvern = 1000;
        @Config.Comment(value={"The energy cost per shield point for draconic armour. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=0)
        public int shieldRecoveryEnergyDraconic = 1000;
        @Config.Comment(value={"The energy cost per shield point for chaotic armour. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=0)
        public int shieldRecoveryEnergyChaotic = 1000;
        @Config.Comment(value={"The percentage bonus of entropy dealt to energy shields per level of the entropic trait.", "Normally, 1/20 of the raw damage dealt to an energy shield is applied as entropy."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double entropicBonusEntropyPerLevel = 1.0;
        @Config.Comment(value={"Causes only the first level of the entropic modifier to consume a modifier slot."})
        @Config.RequiresMcRestart
        public boolean entropicOnlyUsesOneModifier = false;
        @Config.Comment(value={"The percentage of damage converted to chaos damage per level of the primordial trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double primordialConversionPerLevel = 0.04;
        @Config.Comment(value={"Causes only the first level of the primordial modifier to consume a modifier slot."})
        @Config.RequiresMcRestart
        public boolean primordialOnlyUsesOneModifier = false;
        @Config.Comment(value={"The percentage of energy burned per hit per level of the flux burn modifier."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double fluxBurnPortionPerLevel = 0.01;
        @Config.Comment(value={"The minimum amount of energy burned per hit per level of the flux burn modifier."})
        @Config.RangeInt(min=0, max=0x19999999)
        public int fluxBurnMinPerLevel = 256;
        @Config.Comment(value={"The maximum amount of energy burned per hit per level of the flux burn modifier.", "Set to zero to disable the cap."})
        @Config.RangeInt(min=0, max=0x19999999)
        public int fluxBurnMaxPerLevel = 320000;
        @Config.Comment(value={"The amount of energy burned per one point of damage for the flux burn ability.", "That is to say, if you burn exactly this much energy, you'll deal exactly one point of damage."})
        @Config.RangeInt(min=1)
        public int fluxBurnEnergy = 16000;
        @Config.Comment(value={"Causes only the first level of the flux burn modifier to consume a modifier slot."})
        @Config.RequiresMcRestart
        public boolean fluxBurnOnlyUsesOneModifier = false;
        @Config.Comment(value={"The amount of energy required for the final guard ability. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=1)
        public int finalGuardEnergy = 10000000;
        @Config.Comment(value={"Causes only the first level of the reaping modifier to consume a modifier slot."})
        @Config.RequiresMcRestart
        public boolean reapingOnlyUsesOneModifier = false;
        @Config.Comment(value={"The percentage of chaos damage mitigated per level of the chaos resistance modifier.", "Note that this stacks additively across all pieces of armour."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double chaosResistPercentagePerLevel = 0.048;
        @Config.Comment(value={"Causes only the first level of the chaos resistance armour modifier to consume a modifier slot.", "Only useful with Construct's Armoury installed."})
        @Config.RequiresMcRestart
        public boolean chaosResistOnlyUsesOneModifier = false;
        @Config.Comment(value={"If enabled, damage blocked by energy shields will still grant tool experience.", "Only useful with both Construct's Armoury and Tinkers Tool Leveling installed."})
        public boolean shieldedDamageGrantsToolXp = false;

        public int getBaseRfCapacity(int tier) {
            return DraconicEvolution.triSwitch(tier, this.baseRfCapacityWyvern, this.baseRfCapacityDraconic, this.baseRfCapacityChaotic, 1);
        }

        public int getRfTransfer(int tier) {
            return DraconicEvolution.triSwitch(tier, this.rfTransferWyvern, this.rfTransferDraconic, this.rfTransferChaotic, 1);
        }

        public int getOperationEnergy(int tier) {
            return DraconicEvolution.triSwitch(tier, this.operationEnergyWyvern, this.operationEnergyDraconic, this.operationEnergyChaotic, 1);
        }

        public int getBaseShieldCapacity(int tier) {
            return DraconicEvolution.triSwitch(tier, this.baseShieldCapacityWyvern, this.baseShieldCapacityDraconic, this.baseShieldCapacityChaotic, 0);
        }

        public double getBaseShieldRecovery(int tier) {
            return DraconicEvolution.triSwitch(tier, this.baseShieldRecoveryWyvern, this.baseShieldRecoveryDraconic, this.baseShieldRecoveryChaotic, 0.0);
        }

        public int getShieldRecoveryEnergy(int tier) {
            return DraconicEvolution.triSwitch(tier, this.shieldRecoveryEnergyWyvern, this.shieldRecoveryEnergyDraconic, this.shieldRecoveryEnergyChaotic, 0);
        }

        private static <T> T triSwitch(int tier, T wyvern, T draconic, T chaotic, T defaultValue) {
            switch (tier) {
                case 1: {
                    return wyvern;
                }
                case 2: {
                    return draconic;
                }
                case 3: {
                    return chaotic;
                }
            }
            return defaultValue;
        }
    }

    public static class ConstructsArmoury {
        @Config.Comment(value={"Fixes the bug where Construct's Armoury armour can take damage even with traits that prevent it.", "Only useful with Construct's Armoury installed!"})
        public boolean fixConArmArmourDamage = true;
    }

    public static class Botania {
        @Config.Comment(value={"The amount of mana used to repair one point of durability by the mana-infused trait.", "Also the amount of mana contained in a burst created by the gaia's wrath trait."})
        @Config.RangeInt(min=1)
        public int manaInfusedCost = 75;
        @Config.Comment(value={"The fraction of damage converted to mana gain by the aura siphon trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double auraSiphonMultiplier = 2.5;
        @Config.Comment(value={"The number of ticks between each proc by the aura-infused trait. Only useful with Construct's Armoury."})
        @Config.RangeInt(min=1)
        public int auraInfusedDelay = 20;
        @Config.Comment(value={"The probability of spawning a pixie on each weapon attack by the voice of the fae trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double faeVoiceProbabilityWeapon = 0.05;
        @Config.Comment(value={"The probability of spawning a pixie when hit for a helmet with the voice of the fae trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double faeVoiceProbabilityHelmet = 0.11;
        @Config.Comment(value={"The probability of spawning a pixie when hit for a chestplate with the voice of the fae trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double faeVoiceProbabilityChestplate = 0.17;
        @Config.Comment(value={"The probability of spawning a pixie when hit for leggings with the voice of the fae trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double faeVoiceProbabilityLeggings = 0.15;
        @Config.Comment(value={"The probability of spawning a pixie when hit for boots with the voice of the fae trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double faeVoiceProbabilityBoots = 0.09;
        @Config.Comment(value={"The mana discount percentage granted per level by a helmet with the mana affinity trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double manaAffinityDiscountHelmet = 0.015;
        @Config.Comment(value={"The mana discount percentage granted per level by a chestplate with the mana affinity trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double manaAffinityDiscountChestplate = 0.04;
        @Config.Comment(value={"The mana discount percentage granted per level by leggings with the mana affinity trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double manaAffinityDiscountLeggings = 0.03;
        @Config.Comment(value={"The mana discount percentage granted per level by boots with the mana affinity trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double manaAffinityDiscountBoots = 0.015;

        public double getFaeVoiceProbabilityArmour(EntityEquipmentSlot slot) {
            return TconEvoConfig.armourSwitch(slot, this.faeVoiceProbabilityHelmet, this.faeVoiceProbabilityChestplate, this.faeVoiceProbabilityLeggings, this.faeVoiceProbabilityBoots, 0.0);
        }

        public double getManaAffinityDiscount(EntityEquipmentSlot slot) {
            return TconEvoConfig.armourSwitch(slot, this.manaAffinityDiscountHelmet, this.manaAffinityDiscountChestplate, this.manaAffinityDiscountLeggings, this.manaAffinityDiscountBoots, 0.0);
        }
    }

    public static class BloodMagic {
        @Config.Comment(value={"The cost, in LP, per durability point consumed by bloodbound tools."})
        @Config.RangeInt(min=1)
        public int bloodboundToolCost = 5;
        @Config.Comment(value={"The cost, in LP, per durability point consumed by bloodbound armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int bloodboundArmourCost = 25;
        @Config.Comment(value={"The probability of dropping a blood shard per mob slain with the crystalys trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double crystalysDropProbability = 0.2;
        @Config.Comment(value={"The threshold values of demon will required for each tier of power for sentient tools.", "Note that changing the length of this array will change the number of tiers."})
        public double[] sentientTierThresholds = new double[]{16.0, 60.0, 200.0, 400.0, 1000.0, 2000.0, 4000.0};
        @Config.Comment(value={"The threshold values of demon will required for each tier of power for sentient armour.", "Note that changing the length of this array will change the number of tiers.", "Only useful with Construct's Armoury installed!"})
        public double[] sentientArmourTierThresholds = new double[]{30.0, 200.0, 600.0, 1500.0, 4000.0, 6000.0, 8000.0, 16000.0};
        @Config.Comment(value={"The base demon will cost per operation performed by sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientWillCostBase = 0.05;
        @Config.Comment(value={"The additional demon will cost per tier of power per operation performed by sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientWillCostPerLevel = 0.15;
        @Config.Comment(value={"The base demon will cost per damage point absorbed by sentient armour."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientArmourWillCostBase = 0.1;
        @Config.Comment(value={"The additional demon will cost per tier of power per damage point absorbed by sentient armour."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientArmourWillCostPerLevel = 0.05;
        @Config.Comment(value={"The additional dig speed granted per tier of power for sentient tools."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double sentientDigSpeedPerLevel = 0.75;
        @Config.Comment(value={"The additional flat attack damage granted per tier of raw will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientRawDamagePerLevel = 0.5;
        @Config.Comment(value={"The additional percentage damage reduction granted per tier of raw will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientRawArmourProtectionPerLevel = 0.028;
        @Config.Comment(value={"The base flat attack damage granted for corrosive will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientCorrosiveDamageBase = 0.0;
        @Config.Comment(value={"The additional flat attack damage granted per tier of corrosive will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientCorrosiveDamagePerLevel = 0.5;
        @Config.Comment(value={"The base poison duration, in ticks, for corrosive will on sentient tools.", "Also used for the poison effect corrosive sentient armour."})
        @Config.RangeInt(min=1)
        public int sentientCorrosivePoisonDurationBase = 16;
        @Config.Comment(value={"The additional poison duration, in ticks, per tier of corrosive will on sentient tools.", "Also used for the poison effect corrosive sentient armour."})
        @Config.RangeInt(min=0)
        public int sentientCorrosivePoisonDurationPerLevel = 16;
        @Config.Comment(value={"The base percentage damage reduction granted per tier of corrosive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientCorrosiveArmourProtectionBase = 0.0;
        @Config.Comment(value={"The additional percentage damage reduction granted per tier of corrosive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientCorrosiveArmourProtectionPerLevel = 0.028;
        @Config.Comment(value={"The base flat attack damage granted for destructive will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveDamageBase = 0.25;
        @Config.Comment(value={"The additional flat attack damage granted per tier of destructive will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveDamagePerLevel = 0.75;
        @Config.Comment(value={"The base percentage reduction in attack speed incurred by destructive will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveAttackSpeedBase = 0.0;
        @Config.Comment(value={"The additional percentage reduction in attack speed incurred per tier of destructive will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveAttackSpeedPerLevel = 0.09;
        @Config.Comment(value={"The base percentage damage reduction granted per tier of destructive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientDestructiveArmourProtectionBase = 0.0;
        @Config.Comment(value={"The additional percentage damage reduction granted per tier of destructive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientDestructiveArmourProtectionPerLevel = 0.028;
        @Config.Comment(value={"The base flat attack damage granted for destructive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveArmourAttackDamageBase = 0.25;
        @Config.Comment(value={"The additional flat attack damage granted per tier of destructive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveArmourAttackDamagePerLevel = 0.25;
        @Config.Comment(value={"The base percentage reduction in attack speed incurred by destructive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveArmourAttackSpeedBase = 0.0;
        @Config.Comment(value={"The additional percentage reduction in attack speed incurred per tier of destructive will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientDestructiveArmourAttackSpeedPerLevel = 0.01;
        @Config.Comment(value={"The base flat attack damage granted for vengeful will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulDamageBase = -0.4;
        @Config.Comment(value={"The additional flat attack damage granted per tier of vengeful will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulDamagePerLevel = 0.4;
        @Config.Comment(value={"The base percentage attack speed granted per tier of vengeful will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulAttackSpeedBase = 0.09;
        @Config.Comment(value={"The additional percentage attack speed granted per tier of vengeful will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulAttackSpeedPerLevel = 0.09;
        @Config.Comment(value={"The base percentage move speed granted per tier of vengeful will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulMoveSpeedBase = 0.0;
        @Config.Comment(value={"The additional percentage move speed granted per tier of vengeful will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulMoveSpeedPerLevel = 0.05;
        @Config.Comment(value={"The base percentage damage reduction granted per tier of vengeful will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientVengefulArmourProtectionBase = 0.0;
        @Config.Comment(value={"The additional percentage damage reduction granted per tier of vengeful will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientVengefulArmourProtectionPerLevel = 0.028;
        @Config.Comment(value={"The base percentage move speed granted per tier of vengeful will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulArmourMoveSpeedBase = 0.0;
        @Config.Comment(value={"The additional percentage move speed granted per tier of vengeful will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientVengefulArmourMoveSpeedPerLevel = 0.03;
        @Config.Comment(value={"The base flat attack damage granted for steadfast will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientSteadfastDamageBase = -0.4;
        @Config.Comment(value={"The additional flat attack damage granted per tier of steadfast will on sentient tools."})
        @Config.RangeDouble(min=0.0, max=1.0E9)
        public double sentientSteadfastDamagePerLevel = 0.4;
        @Config.Comment(value={"The base absorption duration, in ticks, for steadfast will on sentient tools."})
        @Config.RangeInt(min=1)
        public int sentientSteadfastAbsorptionDurationBase = 100;
        @Config.Comment(value={"The additional absorption duration, in ticks, per tier of steadfast will on sentient tools."})
        @Config.RangeInt(min=0)
        public int sentientSteadfastAbsorptionDurationPerLevel = 100;
        @Config.Comment(value={"The percentage of enemy max health gained as absorption per proc of steadfast will on sentient tools.", "Note that no more than 20 points of absorption can be gained from steadfast tools at a time."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double sentientSteadfastAbsorptionHealthRatio = 0.05;
        @Config.Comment(value={"The base percentage damage reduction granted per tier of steadfast will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientSteadfastArmourProtectionBase = 0.06;
        @Config.Comment(value={"The additional percentage damage reduction granted per tier of steadfast will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientSteadfastArmourProtectionPerLevel = 0.022;
        @Config.Comment(value={"The base percentage knockback resistance granted per tier of steadfast will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientSteadfastArmourKnockbackResistBase = 0.0;
        @Config.Comment(value={"The additional percentage knockback resistance granted per tier of steadfast will on sentient armour.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sentientSteadfastArmourKnockbackResistPerLevel = 0.1;
        @Config.Comment(value={"The total possible percentage of damage mitigated by the soul guard trait.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double soulGuardDamageReduction = 0.25;
        @Config.Comment(value={"The cost, in LP, to mitigate one point of damage with the soul guard trait.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int soulGuardCost = 50;
        @Config.Comment(value={"The percentage penalty to damage reduction by soul guard when incoming damage is armour-piercing.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double soulGuardPiercingPenalty = 0.1;
        @Config.Comment(value={"The percentage penalty to damage reduction by soul guard per level of the soul fray debuff.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double soulGuardFrayedPenalty = 0.33;
        @Config.Comment(value={"The base static demon will drop rate for the willful trait.", "Dropped will is computed as the static drop rate scaled by the health pool size of the killed mob's .", "Additionally, a random bonus amount of will is added, up to the bonus drop rate.", "Drop rates increase based on the level of the sentient trait (and not the willful trait!).", "For weapons that have the willful trait but not the sentient trait, only the base drop rates are used."})
        @Config.RangeDouble(min=0.0)
        public double willfulStaticDropBase = 1.0;
        @Config.Comment(value={"The additional static demon will drop rate per level of the sentient trait.", "See `willfulStaticDropBase` for more details."})
        @Config.RangeDouble(min=0.0)
        public double willfulStaticDropPerLevel = 0.43;
        @Config.Comment(value={"The base bonus demon will drop rate for the willful trait.", "See `willfulStaticDropBase` for more details."})
        @Config.RangeDouble(min=0.0)
        public double willfulBonusDropBase = 2.0;
        @Config.Comment(value={"The additional bonus demon will drop rate per level of the sentient trait.", "See `willfulStaticDropBase` for more details."})
        @Config.RangeDouble(min=0.0)
        public double willfulBonusDropPerLevel = 2.3;
        @Config.Comment(value={"The probability of a mob becoming soul-snared upon attacking armour with the willful trait.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double willfulArmourEnsnareProbability = 0.25;
        @Config.Comment(value={"The duration, in ticks, of the soul snare effect applied by armour with the willful trait.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int willfulArmourEnsnareDuration = 300;
    }

    public static class Avaritia {
        @Config.Comment(value={"The probability of a neutron pile dropping from breaking a block or killing a mob using the condensing trait.", "Note that this stacks additively for each tool part with the condensing trait used in a tool."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double condensingDropProbability = 0.005;
        @Config.Comment(value={"Can tools with the omnipotence trait break unbreakable blocks (e.g. bedrock)?", "This is a setting that server owners should probably be careful with."})
        public boolean omnipotenceBreaksUnbreakable = false;
        @Config.Comment(value={"Can weapons with the omnipotence trait hit players in creative mode?", "This is a setting that server owners should probably be careful with."})
        public boolean omnipotenceHitsCreative = false;
    }

    public static class AstralSorcery {
        @Config.Comment(value={"The bonus mining speed percentage granted by attunement when the constellation is in the sky."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double attunementBonusEfficiency = 0.1;
        @Config.Comment(value={"The bonus attack damage percentage granted by attunement when the constellation is in the sky."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double attunementBonusDamage = 0.1;
        @Config.Comment(value={"The duration, in ticks, of the regeneration granted by tools attuned to aevitas."})
        @Config.RangeInt(min=1)
        public int toolAevitasRegenDuration = 100;
        @Config.Comment(value={"The duration, in ticks, of the resistance granted by tools attuned to armara."})
        @Config.RangeInt(min=1)
        public int toolArmaraResistanceDuration = 100;
        @Config.Comment(value={"The bonus damage percentage granted by tools attuned to discidia."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double toolDiscidiaBonusDamage = 0.25;
        @Config.Comment(value={"The bonus efficiency granted by tools attuned to evorsio."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double toolEvorsioBonusEfficiency = 0.25;
        @Config.Comment(value={"The duration, in ticks, of the speed granted by tools attuned to vicio."})
        @Config.RangeInt(min=1)
        public int toolVicioSpeedDuration = 100;
        @Config.Comment(value={"The duration, in SECONDS, of the fire set by tools attuned to fornax."})
        @Config.RangeInt(min=1)
        public int toolFornaxFireDuration = 10;
        @Config.Comment(value={"The duration, in ticks, of the time freeze caused by tools attuned to horologium."})
        @Config.RangeInt(min=1)
        public int toolHorologiumFreezeDuration = 16;
        @Config.Comment(value={"The duration, in ticks, of the glowing effect granted by tools attuned to lucerna."})
        @Config.RangeInt(min=1)
        public int toolLucernaGlowingDuration = 200;
        @Config.Comment(value={"The level of fortune granted by tools attuned to mineralis."})
        @Config.RangeInt(min=1, max=32767)
        public int toolMineralisFortuneLevel = 3;
        @Config.Comment(value={"The probability of repairing one durability each second on tools attuned to pelotrio."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double toolPelotrioRepairProbability = 0.17;
        @Config.Comment(value={"The bonus armour protection afforded by attunement when the constellation is in the sky.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double attunementBonusProtection = 0.1;
        @Config.Comment(value={"The duration, in ticks, of the regeneration granted by armour attuned to aevitas.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int armourAevitasRegenDuration = 100;
        @Config.Comment(value={"The bonus armour protection (defense and toughness) afforded by armour attuned to armara.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double armourArmaraBonusProtection = 0.25;
        @Config.Comment(value={"The fraction of damage reflected by armour attuned to discidia.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double armourDiscidiaReflectRatio = 0.3;
        @Config.Comment(value={"The duration, in ticks, of the speed granted by armour attuned to vicio.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int armourVicioSpeedDuration = 100;
        @Config.Comment(value={"The probability of a flare spawning for each hit on armour attuned to bootes.", "Note that each armour piece makes an independent roll, allowing up to 4 flares to spawn per hit.", "Only useful with Construct's Armoury installed!"})
        public double armourBootesFlareProbability = 0.09f;
        @Config.Comment(value={"The duration, in ticks, of the time freeze incurred by armour attuned to horologium.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int armourHorologiumFreezeDuration = 64;
        @Config.Comment(value={"The range of the time freeze incurred by armour attuned to horologium.", "Don't make this too large; it will probably crash servers.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=1.0, max=3.4028234663852886E38)
        public double armourHorologiumFreezeRange = 6.0;
        @Config.Comment(value={"The cooldown duration, in ticks, between time freeze procs on armour attuned to horologium.", "This should probably be a number larger than the time freeze duration.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeInt(min=1)
        public int armourHorologiumCooldown = 200;
        @Config.Comment(value={"The probability of repairing one durability each second on armour attuned to pelotrio.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double armourPelotrioRepairProbability = 0.11;
    }

    public static class Client {
        @Config.Comment(value={"Allows Tinkers' Evolution to inject its custom model render handlers.", "If your tool rendering starts acting strange, disabling this might fix it."})
        @Config.RequiresMcRestart
        public boolean useFancyModelRenders = true;
    }

    public static class Artifacts {
        @Config.Comment(value={"Whether artifacts should be enabled or not."})
        @Config.RequiresMcRestart
        public boolean enabled = true;
        @Config.Comment(value={"The minimum number of free modifiers artifacts should have as a baseline.", "This is useful for working around lower baselines set by Tool Leveling.", "Set to -1 to just use the default."})
        @Config.RangeInt(min=-1, max=3)
        public int freeModBaseline = 3;
        @Config.Comment(value={"The probabilities of an artifact being generated in various loot tables.", "Each entry should be formatted `<loot table name>,<probability>`."})
        @Config.RequiresMcRestart
        public String[] lootProbabilities = new String[]{"chests/abandoned_mineshaft,0.02", "chests/desert_pyramid,0.08", "chests/end_city_treasure,0.15", "chests/igloo_chest,0.05", "chests/jungle_temple,0.08", "chests/nether_bridge,0.02", "chests/simple_dungeon,0.3", "chests/stronghold_corridor,0.04", "chests/stronghold_crossing,0.04", "chests/stronghold_library,0.15", "chests/village_blacksmith,0.1", "chests/woodland_mansion,0.25"};
    }

    public static class Tweaks {
        @Config.Comment(value={"A multiplier for the speed at which materials melt in heat-based machines.", "This affects the smeltery as well as the heater and high oven from Tinkers' Complement.", "Set to 1 to retain the default melt speed. Set to 0 if you want melting to be impossible for some reason."})
        @Config.RangeDouble(min=0.0)
        public double meltSpeedMultiplier = 1.0;
        @Config.Comment(value={"Disables the damage cutoff mechanic, which normally limits the attack damage stat on tools.", "Enabling this will not automatically fix tools built before it was enabled!"})
        public boolean disableDamageCutoff = false;
    }

    public static class Tools {
        @Config.Comment(value={"Whether to enable the sceptre or not.", "If disabled, the recipe and book pages are removed."})
        @Config.RequiresMcRestart
        public boolean sceptreEnabled = true;
    }

    public static class General {
        @Config.Comment(value={"The minimum value for the \"damage taken\" attribute.", "If set to 1, then damage reduction will not work at all."})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresMcRestart
        public double attrDamageTakenMin = 0.0;
        @Config.Comment(value={"The maximum value for the \"damage taken\" attribute."})
        @Config.RangeDouble(min=1.0)
        @Config.RequiresMcRestart
        public double attrDamageTakenMax = 1.0E9;
        @Config.Comment(value={"The maximum value for the \"evasion\" attribute.", "If set to 0, then evasion will not work at all."})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresMcRestart
        public double attrEvasionMax = 1.0;
        @Config.Comment(value={"The minimum value for the \"healing received\" attribute.", "If set to 1, then heal reduction will not work at all."})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresMcRestart
        public double attrHealingReceivedMin = 0.0;
        @Config.Comment(value={"The maximum value for the \"healing received\" attribute.", "If set to 1, then heal amplification will not work at all."})
        @Config.RangeDouble(min=1.0)
        @Config.RequiresMcRestart
        public double attrHealingReceivedMax = 1.0E9;
        @Config.Comment(value={"The additional bonus damage percentage granted per level of the damage boost effect."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double effectDamageBoostBonusDamage = 0.05;
        @Config.Comment(value={"The additional percentage of damage mitigated per level of the damage reduction effect."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double effectDamageReductionPercentage = 0.04;
        @Config.Comment(value={"The fraction of healing that is mitigated by the mortal wounds debuff."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double effectMortalWoundsHealReduction = 0.75;
        @Config.Comment(value={"The minimum amount of health a player can drop to while under the immortality effect.", "Setting this to zero will make the immortality effect completely useless."})
        @Config.RangeDouble(min=1.0)
        public double effectImmortalityMinHealth = 1.0;
        @Config.Comment(value={"The amount of flat bonus magical damage dealt per level of the aftershock trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitAftershockDamage = 2.0;
        @Config.Comment(value={"The duration, in ticks, of the damage boost effect gained from the battle furor trait.", "Each additional proc of the trait refreshes the duration of the effect."})
        public int traitBattleFurorDuration = 100;
        @Config.Comment(value={"The maximum level of damage boost that can be gained from the battle furor trait."})
        public int traitBattleFurorMaxStacks = 9;
        @Config.Comment(value={"The probability of creating a blast on block break with the blasting trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitBlastingBlockProbability = 0.05;
        @Config.Comment(value={"The probability of creating a blast on hitting entities with the blasting trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitBlastingAttackProbability = 0.33;
        @Config.Comment(value={"The probability of projectile exploding on hitting a block with the blasting trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitBlastingProjectileProbability = 0.33;
        @Config.Comment(value={"The magnitude of the blast created by the blasting trait. This should probably not be too large..."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitBlastingMagnitude = 1.0;
        @Config.Comment(value={"Whether blasts creating by the blasting trait will destroy blocks or not."})
        public boolean traitBlastingDamagesTerrain = false;
        @Config.Comment(value={"The probability of a hit generating lightning with the chain lightning trait."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitChainLightningProbability = 0.25;
        @Config.Comment(value={"The maximum distance, in blocks, that a chain lightning instance can jump between targets.", "This should probably be reasonably small, since searching large areas can be expensive."})
        @Config.RangeDouble(min=0.0)
        public double traitChainLightningRange = 3.0;
        @Config.Comment(value={"The maximum number of additional targets that can be bounced to by a single chain lightning instance.", "Setting this to zero means the chain lightning will only hit the original target of the attack."})
        @Config.RangeInt(min=0, max=32767)
        public int traitChainLightningBounces = 3;
        @Config.Comment(value={"The fraction of the original attack's damage dealt as chain lightning damage."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitChainLightningDamageMultiplier = 0.25;
        @Config.Comment(value={"The duration, in ticks, of the slow applied by the chilling touch trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitChillingTouchSlowDuration = 32;
        @Config.Comment(value={"The duration, in ticks, of wither effect applied by the corrupting trait.", "Each additional proc of the trait refreshes the duration of the effect."})
        @Config.RangeInt(min=1)
        public int traitCorruptingWitherDuration = 140;
        @Config.Comment(value={"The maximum level of wither that can be applied by the corrupting trait."})
        @Config.RangeInt(min=0)
        public int traitCorruptingMaxStacks = 5;
        @Config.Comment(value={"The bonus damage percentage at maximum durability for the crystalline trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitCrystallineMaxBonus = 0.2;
        @Config.Comment(value={"The max-health-difference multiplier for computing damage from the culling trait.", "Bonus damage dealt is computed as `n * (attackerHealth - targetHealth)`, where `n` is this config value."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitCullingDifferenceMultiplier = 0.5;
        @Config.Comment(value={"The upper bound for the bonus damage dealt by the culling trait.", "The bonus damage cannot exceed the attack's base damage times this multiplier.", "Set this to zero to disable the upper bound."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitCullingBoundMultiplier = 2.0;
        @Config.Comment(value={"The bonus damage percentage for critical strikes augmented by the deadly precision trait.", "Note that the built-in +50% bonus critical strike damage is applied after this bonus damage."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitDeadlyPrecisionBonusDamage = 0.5;
        @Config.Comment(value={"The amount of healing amplification afforded by each armour piece with the divine grace trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitDivineGraceHealBoost = 0.12;
        @Config.Comment(value={"The energy cost per point of durability absorbed by tools with the energized trait."})
        @Config.RangeInt(min=0)
        public int traitEnergizedEnergyCostTools = 320;
        @Config.Comment(value={"The energy capacity granted per trait level on tools with the energized trait."})
        @Config.RangeInt(min=1)
        public int traitEnergizedEnergyCapacityTools = 400000;
        @Config.Comment(value={"The energy cost per point of durability absorbed by armour with the energized trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=0)
        public int traitEnergizedEnergyCostArmour = 1024;
        @Config.Comment(value={"The energy capacity granted per trait level on armour with the energized trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=0)
        public int traitEnergizedEnergyCapacityArmour = 400000;
        @Config.Comment(value={"The divider used to calculate the maximum energy transfer rate for equipment with the energized trait.", "Transfer rate is calculated as `capacity/n`, where `n` is this config value.", "Set to zero for unlimited transfer rate."})
        @Config.RangeDouble(min=0.0)
        public double traitEnergizedEnergyTransferDivider = 100.0;
        @Config.Comment(value={"The percentage of missing health dealt as bonus damage by the executor trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitExecutorMissingHealthDamage = 0.2;
        @Config.Comment(value={"The maximum amount of damage that can be dealt in a single executor proc.", "Set this to zero to disable the upper bound."})
        @Config.RangeDouble(min=0.0)
        public double traitExecutorDamageMax = 0.0;
        @Config.Comment(value={"The cost, in durability points, of using the fertilizing trait to fertilize a crop."})
        @Config.RangeInt(min=0)
        public int traitFertilizingDurabilityCost = 25;
        @Config.Comment(value={"The duration, in ticks, of the speed granted by the fleet of foot trait."})
        @Config.RangeInt(min=1)
        public int traitFootFleetSpeedDuration = 50;
        @Config.Comment(value={"The bonus flight speed provided per level of the gale force trait."})
        @Config.RangeDouble(min=0.0)
        public double traitGaleForceFlightSpeed = 0.02;
        @Config.Comment(value={"The duration, in ticks, of the regeneration and fire resistance granted by the hearth's embrace trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitHearthEmbraceBuffDuration = 200;
        @Config.Comment(value={"The first health threshold for the juggernaut trait.", "The damage multiplier for the trait is computed in the following way: there are a series of health", "thresholds and for each threshold surpassed by the player's current health amount, the damage multiplier", "is applied once. The distance between the thresholds increases by a multiplier. With the default settings", "of 20 base health, 2 threshold multiplier, and 30% damage multiplier, the player would gain 30% damage", "at 20 health, 60% damage at 40 health, 90% damage at 80 health, and so on. The specific formula used is:", "bonusDamage = damageMult * (log(health/baseHealth) / log(threshFactor) + 1)", "If the threshold multiplier is set to 1, then the threshold scaling is disabled and a linear formula is used instead:", "bonusDamage = damageMult * health / baseHealth"})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitJuggernautHealthBase = 20.0;
        @Config.Comment(value={"The multiplier applied to the previous threshold to compute the next threshold for the juggernaut trait.", "Set to 1 if you want the thresholds to not change (i.e. linearly scaling juggernaut damage).", "See the comment for traitJuggernautHealthBase for more details."})
        @Config.RangeDouble(min=1.0, max=3.4028234663852886E38)
        public double traitJuggernautThresholdFactor = 2.0;
        @Config.Comment(value={"The bonus damage percentage per passed health threshold for the juggernaut trait.", "See the comment for traitJuggernautHealthBase for more details."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitJuggernautDamageMultiplier = 0.3;
        @Config.Comment(value={"The duration, in ticks, of the glowing effect applied by the luminiferous trait."})
        @Config.RangeInt(min=1)
        public int traitLuminiferousGlowingDuration = 160;
        @Config.Comment(value={"The duration, in ticks, of the healing reduction applied by the mortal wounds trait."})
        @Config.RangeInt(min=1)
        public int traitMortalWoundsHealReductionDuration = 100;
        @Config.Comment(value={"The bonus damage percentage for attacks that proc opportunist."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitOpportunistBonusDamage = 0.3;
        @Config.Comment(value={"The bonus damage percentage gained for each point of enemy armour using the overwhelm trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitOverwhelmArmourDamage = 0.015;
        @Config.Comment(value={"The probability of repairing one durability each second for tools with the photosynthetic trait.", "This is the probability in full sunlight; the probability is decreased in lower light and when occluded."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitPhotosyntheticRepairProbability = 0.2;
        @Config.Comment(value={"The probability of repairing one durability each second for armour with the photosynthetic trait.", "This is the probability in full sunlight; the probability is decreased in lower light and when occluded.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitPhotosyntheticArmourRepairProbability = 0.15;
        @Config.Comment(value={"The fraction of damage converted to energy for attacks that proc the piezoelectric trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitPiezoelectricConversionRatio = 36.0;
        @Config.Comment(value={"The duration, in ticks, of the blindness applied by the radiant trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitRadiantBlindnessDuration = 32;
        @Config.Comment(value={"The duration, in ticks, of damage reduction applied by the reactive trait.", "Each additional proc of the trait refreshes the duration of the effect.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitReactiveResistanceDuration = 200;
        @Config.Comment(value={"The maximum level of damage reduction that the reactive trait can stack up to.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=0)
        public int traitReactiveMaxStacks = 20;
        @Config.Comment(value={"The duration, in ticks, of the regeneration applied by the rejuvenating trait."})
        @Config.RangeInt(min=1)
        public int traitRejuvenatingRegenDuration = 64;
        @Config.Comment(value={"The number of ticks of invincibility removed by the relentless trait.", "By default, every mob has 20 ticks of invincibility, but only half of them actually block incoming damage."})
        @Config.RangeInt(min=1)
        public int traitRelentlessInvincibilityReduction = 7;
        @Config.Comment(value={"The fraction of enemy current health dealt as bonus damage by the ruination trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitRuinationHealthMultiplier = 0.04;
        @Config.Comment(value={"The maximum amount of damage that can be dealt in a single ruination proc.", "Set this to zero to disable the upper bound."})
        @Config.RangeDouble(min=0.0)
        public double traitRuinationDamageMax = 0.0;
        @Config.Comment(value={"The duration, in ticks, of the regeneration granted by the second wind trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitSecondWindRegenDuration = 140;
        @Config.Comment(value={"The (inclusive) light level threshold for the invisibility granted by the shadowstep trait.", "Only useful with Construct's Armoury installed."})
        public int traitShadowstepLightThreshold = 3;
        @Config.Comment(value={"The evasion chance granted by each piece of armour with the spectarl trait.", "Only useful with Construct's Armoury installed!"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double traitSpectralEvasionChance = 0.08;
        @Config.Comment(value={"The duration, in ticks, of the root applied by the staggering trait."})
        @Config.RangeInt(min=1)
        public int traitStaggeringRootDuration = 12;
        @Config.Comment(value={"The duration, in ticks, of the weakness applied by the stifling trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitStiflingWeaknessDuration = 100;
        @Config.Comment(value={"The maximum bonus armour effectiveness afforded by the stonebound armour trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeDouble(min=1.0, max=3.4028234663852886E38)
        public double traitStoneboundArmourEffectivenessMax = 0.05;
        @Config.Comment(value={"The duration, in ticks, of the weakness applied by the sundering trait."})
        @Config.RangeInt(min=1)
        public int traitSunderingWeaknessDuration = 100;
        @Config.Comment(value={"The fraction of damage converted to healing by the vampiric trait."})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public double traitVampiricConversionRatio = 0.2;
        @Config.Comment(value={"The duration, in ticks, of the immortality applied by the strength of will trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=1)
        public int traitWillStrengthImmortalityDuration = 200;
        @Config.Comment(value={"The cooldown, in ticks, between procs of the strength of will trait.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=0)
        public int traitWillStrengthCooldown = 0;
        @Config.Comment(value={"The energy capacity divider that determines the durability threshold for the fluxed modifier.", "For a battery storing `s` RF, the tool needs at least `s/n` max durability, where `n` is this config value.", "To disable the durability requirement entirely, set this to zero."})
        @Config.RangeDouble(min=0.0)
        public double modFluxedDurabilityThresholdDivider = 2000.0;
        @Config.Comment(value={"The energy cost per point of durability absorbed by tools with the fluxed modifier."})
        @Config.RangeInt(min=0)
        public int modFluxedEnergyCostTools = 320;
        @Config.Comment(value={"The energy cost per point of durability absorbed by armour with the fluxed modifier.", "Only useful with Construct's Armoury installed."})
        @Config.RangeInt(min=0)
        public int modFluxedEnergyCostArmour = 1024;
        @Config.Comment(value={"The divider used to calculate the maximum energy transfer rate for tools with the fluxed modifier.", "Transfer rate is calculated as `capacity/n`, where `n` is this config value.", "Set to zero for unlimited transfer rate."})
        @Config.RangeDouble(min=0.0)
        public double modFluxedEnergyTransferDivider = 100.0;
        @Config.Comment(value={"Can the fluxed modifier be re-applied to replace the battery?"})
        public boolean modFluxedReplaceable = true;
        @Config.Comment(value={"Can the photovoltaic modifier be re-applied to replace the solar panel?"})
        public boolean modPhotovoltaicReplaceable = true;
    }
}

