/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.artifact;

import com.google.gson.JsonObject;
import io.github.phantamanta44.libnine.util.helper.JsonUtils9;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.artifact.type.ArtifactType;

public class ArtifactLoader {
    @Nullable
    private Path artifactDir;

    public void setArtifactDir(Path artifactDir) {
        if (this.artifactDir != null) {
            throw new IllegalStateException("Artifact directory is already set!");
        }
        this.artifactDir = artifactDir;
    }

    public void loadArtifacts() {
        if (this.artifactDir == null) {
            throw new IllegalStateException("Artifact directory is not set!");
        }
        if (TconEvoConfig.artifacts.enabled) {
            TconEvoMod.LOGGER.info("Loading artifacts...");
            try {
                TconEvoMod.PROXY.getArtifactRegistry().registerArtifacts(Files.list(this.artifactDir).filter(f -> f.getFileName().toString().endsWith(".json")).map(path -> {
                    String artifactId;
                    TconEvoMod.LOGGER.debug("Loading artifact file: {}", path);
                    try {
                        artifactId = path.getFileName().toString();
                        artifactId = artifactId.substring(0, artifactId.length() - 5);
                    }
                    catch (Exception e) {
                        TconEvoMod.LOGGER.warn("Encountered exception while parsing artifact ID for file: " + path, (Throwable)e);
                        return null;
                    }
                    try {
                        JsonObject dto = JsonUtils9.PARSER.parse((Reader)Files.newBufferedReader(path)).getAsJsonObject();
                        return TconEvoMod.PROXY.getArtifactRegistry().getTypeRegistry().parseArtifact(artifactId, dto);
                    }
                    catch (ArtifactType.BuildingException e) {
                        TconEvoMod.LOGGER.warn("Failed to load artifact \"{}\": {}", (Object)artifactId, (Object)e.getMessage());
                    }
                    catch (Exception e) {
                        TconEvoMod.LOGGER.warn("Encountered exception while loading artifact: " + artifactId, (Throwable)e);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            catch (IOException e) {
                TconEvoMod.LOGGER.error("Encountered exception while loading artifacts!", (Throwable)e);
                TconEvoMod.PROXY.getArtifactRegistry().registerArtifacts(Collections.emptyList());
            }
        }
    }
}

