/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.artifact.type;

import com.google.gson.JsonObject;
import io.github.phantamanta44.libnine.util.nbt.ImmutableNbt;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import xyz.phanta.tconevo.artifact.type.ArtifactType;
import xyz.phanta.tconevo.artifact.type.ArtifactTypeTool;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;

public class ArtifactTypeArmour
implements ArtifactType<Spec> {
    @Override
    public Spec parseArtifactSpec(JsonObject dto) throws ArtifactType.BuildingException {
        return new Spec(JsonUtils.func_151200_h((JsonObject)dto, (String)"name"), ArtifactTypeTool.parseLore(dto), JsonUtils.func_151200_h((JsonObject)dto, (String)"armour"), ArtifactTypeTool.parseMaterials(dto), JsonUtils.func_151208_a((JsonObject)dto, (String)"free_mods", (int)0), ArtifactTypeTool.parseModifiers(dto), JsonUtils.func_151218_a((JsonObject)dto, (String)"data_tag", null));
    }

    @Override
    public ItemStack buildArtifact(Spec spec) throws ArtifactType.BuildingException {
        return ConArmHooks.INSTANCE.buildArmourArtifact(spec);
    }

    public static class Spec {
        public final String name;
        public final List<String> lore;
        public final String armourType;
        public final List<String> materials;
        public final int freeMods;
        public final List<IPair<String, Integer>> modifiers;
        @Nullable
        public final ImmutableNbt<NBTTagCompound> dataTag;

        public Spec(String name, List<String> lore, String armourType, List<String> materials, int freeMods, List<IPair<String, Integer>> modifiers, @Nullable JsonObject dataTag) {
            this.name = name;
            this.lore = Collections.unmodifiableList(lore);
            this.armourType = armourType;
            this.materials = Collections.unmodifiableList(materials);
            this.freeMods = freeMods;
            this.modifiers = Collections.unmodifiableList(modifiers);
            this.dataTag = dataTag != null ? ImmutableNbt.parseObject((JsonObject)dataTag) : null;
        }
    }
}

