/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.client.book;

import java.util.List;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import xyz.phanta.tconevo.client.util.TconReflectClient;

public class BookTransformerListingOverflow
extends SectionTransformer {
    public BookTransformerListingOverflow(String sectionName) {
        super(sectionName);
    }

    public void transform(BookData book, SectionData section) {
        if (!section.pages.isEmpty()) {
            PageData page = (PageData)section.pages.get(0);
            if (page.content instanceof ContentListing) {
                ContentListing listing = (ContentListing)page.content;
                List<TextData> entries = TconReflectClient.getEntries(listing);
                int pageSizeFirst = 2 * (int)Math.ceil(((float)GuiBook.PAGE_HEIGHT - (listing.title != null ? 49.0f : 29.0f)) / 9.0f);
                if (entries.size() > pageSizeFirst) {
                    int pageSize = 2 * (int)Math.ceil(((float)GuiBook.PAGE_HEIGHT - 29.0f) / 9.0f);
                    int index = 0;
                    for (int entryNdx = pageSizeFirst; entryNdx < entries.size(); entryNdx += pageSize) {
                        this.addListingPage(section, index++, entries, entryNdx, Math.min(pageSize, entries.size() - entryNdx));
                    }
                    entries.subList(pageSizeFirst, entries.size()).clear();
                }
            }
        }
    }

    private void addListingPage(SectionData section, int index, List<TextData> entries, int from, int count) {
        ContentListing listing = new ContentListing();
        List<TextData> newEntries = TconReflectClient.getEntries(listing);
        for (int i = 0; i < count; ++i) {
            newEntries.add(entries.get(from + i));
        }
        PageData page = new PageData(true);
        page.source = section.source;
        page.parent = section;
        page.name = "listing_ext_" + index;
        page.content = listing;
        page.load();
        section.pages.add(index + 1, page);
    }
}

