/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.client.render.material;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.material.deserializers.AbstractRenderInfoDeserializer;
import xyz.phanta.tconevo.client.handler.TextureMapHandler;
import xyz.phanta.tconevo.client.render.texture.EdgeFindingTexture;
import xyz.phanta.tconevo.client.render.texture.MaybeTextureColouredTexture;

public class CosmicMaterialRenderInfo
extends MaterialRenderInfo.AbstractMaterialRenderInfo {
    private final ResourceLocation texturePath;

    public CosmicMaterialRenderInfo(ResourceLocation texturePath) {
        this.texturePath = texturePath;
    }

    public TextureAtlasSprite getTexture(ResourceLocation baseTexture, String location) {
        return new CosmicTexture(this.texturePath, baseTexture, location);
    }

    public static class Deserializer
    extends AbstractRenderInfoDeserializer {
        private String texture;

        public MaterialRenderInfo getMaterialRenderInfo() {
            return new CosmicMaterialRenderInfo(new ResourceLocation(this.texture));
        }
    }

    public static class CosmicTexture
    extends MaybeTextureColouredTexture {
        private final CosmicMaskTexture maskTexture;

        protected CosmicTexture(ResourceLocation texturePath, ResourceLocation baseTextureLocation, String spriteName) {
            super(texturePath, baseTextureLocation, spriteName);
            this.maskTexture = new CosmicMaskTexture(baseTextureLocation, spriteName);
            TextureMapHandler.INSTANCE.registerSprite((TextureAtlasSprite)this.maskTexture);
        }

        @Nullable
        public TextureAtlasSprite getMaskTexture() {
            return this.maskTexture.nonEmpty ? this.maskTexture : null;
        }

        private static class CosmicMaskTexture
        extends EdgeFindingTexture {
            boolean nonEmpty = false;

            protected CosmicMaskTexture(ResourceLocation baseTextureLocation, String spriteName) {
                super(baseTextureLocation, spriteName + "_cosmic");
            }

            @Override
            protected int processEdgePixel(int colour) {
                return 0;
            }

            @Override
            protected int processInnerPixel(int colour) {
                this.nonEmpty = true;
                return -1;
            }
        }
    }
}

