/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import xyz.phanta.tconevo.coremod.TconEvoCoreMod;
import xyz.phanta.tconevo.coremod.transform.TransformAstralAttunement;
import xyz.phanta.tconevo.coremod.transform.TransformBreakUnbreakable;
import xyz.phanta.tconevo.coremod.transform.TransformCaptureDuplicateMaterials;
import xyz.phanta.tconevo.coremod.transform.TransformCaptureMaterialProperties;
import xyz.phanta.tconevo.coremod.transform.TransformCustomMaterialRender;
import xyz.phanta.tconevo.coremod.transform.TransformDisableDamageCutoff;
import xyz.phanta.tconevo.coremod.transform.TransformFixArmourDamage;
import xyz.phanta.tconevo.coremod.transform.TransformFixDraconicJei;
import xyz.phanta.tconevo.coremod.transform.TransformGregTechRecipeCrash;
import xyz.phanta.tconevo.coremod.transform.TransformImprovedToolBuilding;
import xyz.phanta.tconevo.coremod.transform.TransformItemStackBar;
import xyz.phanta.tconevo.coremod.transform.TransformMaterialisConArmCrash;
import xyz.phanta.tconevo.coremod.transform.TransformModifyMeltSpeed;
import xyz.phanta.tconevo.coremod.transform.TransformThaumInfusionEnchantment;
import xyz.phanta.tconevo.coremod.transform.TransformThaumVisDiscount;
import xyz.phanta.tconevo.coremod.transform.TransformUniquePartTraits;
import xyz.phanta.tconevo.coremod.transform.TransformUseJeiFancyRender;
import xyz.phanta.tconevo.coremod.util.SafeClassWriter;

public class TconEvoClassTransformer
implements IClassTransformer {
    private static final boolean DEBUG = false;
    private static final Map<String, Transform> TRANSFORMS = new HashMap<String, Transform>();

    public byte[] transform(String name, String niceName, byte[] code) {
        Transform tform = TRANSFORMS.get(niceName);
        if (tform != null) {
            TconEvoCoreMod.LOGGER.info("Applying transform \"{}\" to class: {}", (Object)tform.getName(), (Object)niceName);
            ClassReader reader = new ClassReader(code);
            SafeClassWriter writer = new SafeClassWriter(reader, tform.getWriteFlags(), this.getClass().getClassLoader());
            reader.accept(tform.createTransformer(niceName, 327680, (ClassVisitor)writer), tform.getReadFlags());
            byte[] newCode = writer.toByteArray();
            return newCode;
        }
        return code;
    }

    static {
        for (Transform tform : Arrays.asList(new TransformAstralAttunement(), new TransformBreakUnbreakable(), new TransformCaptureDuplicateMaterials(), new TransformCaptureMaterialProperties(), new TransformCustomMaterialRender(), new TransformDisableDamageCutoff(), new TransformFixArmourDamage(), new TransformFixDraconicJei(), new TransformGregTechRecipeCrash(), new TransformImprovedToolBuilding(), new TransformItemStackBar(), new TransformMaterialisConArmCrash(), new TransformModifyMeltSpeed(), new TransformThaumInfusionEnchantment(), new TransformThaumVisDiscount(), new TransformUniquePartTraits(), new TransformUseJeiFancyRender())) {
            tform.getClasses(c -> TRANSFORMS.put((String)c, tform));
        }
    }

    public static interface Transform {
        public String getName();

        default public int getReadFlags() {
            return 0;
        }

        default public int getWriteFlags() {
            return 0;
        }

        public void getClasses(Consumer<String> var1);

        public ClassVisitor createTransformer(String var1, int var2, ClassVisitor var3);
    }
}

