/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.transform;

import java.util.Objects;
import java.util.function.Consumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import xyz.phanta.tconevo.coremod.TconEvoClassTransformer;
import xyz.phanta.tconevo.coremod.TconEvoCoreMod;
import xyz.phanta.tconevo.coremod.util.InsnMatcher;
import xyz.phanta.tconevo.coremod.util.InsnWriter;
import xyz.phanta.tconevo.coremod.util.MethodRewriter;

public class TransformAstralAttunement
implements TconEvoClassTransformer.Transform {
    private static final String TYPE_ATT_ALTAR = "hellfirepvp/astralsorcery/common/tile/TileAttunementAltar";

    @Override
    public String getName() {
        return "Astral Attunement Workaround";
    }

    @Override
    public int getWriteFlags() {
        return 3;
    }

    @Override
    public void getClasses(Consumer<String> collector) {
        collector.accept("hellfirepvp.astralsorcery.common.tile.TileAttunementAltar");
    }

    @Override
    public ClassVisitor createTransformer(String className, int apiVersion, ClassVisitor downstream) {
        return new ClassTransformerTileAttunementAltar(apiVersion, downstream);
    }

    private static class MethodRewriterUpdate
    extends MethodRewriter {
        private static final InsnMatcher MATCH_CRAFTING_CHECK = InsnMatcher.sequence(InsnMatcher.varInsn(25, 0), InsnMatcher.fieldInsn(180, "hellfirepvp/astralsorcery/common/tile/TileAttunementAltar", "serverSyncAttTick", "I"), InsnMatcher.intInsn(17, 500), InsnMatcher.anyInsn(161));
        private static final InsnMatcher MATCH_GET_THROWER = InsnMatcher.sequence(InsnMatcher.varInsn(25, 0), InsnMatcher.fieldInsn(180, "hellfirepvp/astralsorcery/common/tile/TileAttunementAltar", "activeEntity", "Lnet/minecraft/entity/Entity;"), InsnMatcher.typeInsn(192, "net/minecraft/entity/item/EntityItem"), InsnMatcher.methodInsn(182, "net/minecraft/entity/item/EntityItem", "func_145800_j", "()Ljava/lang/String;"), InsnMatcher.anyInsn(58));
        private static final InsnMatcher MATCH_DROP_ITEM = InsnMatcher.sequence(InsnMatcher.varInsn(25, 0), InsnMatcher.fieldInsn(180, "hellfirepvp/astralsorcery/common/tile/TileAttunementAltar", "field_145850_b", "Lnet/minecraft/world/World;"), InsnMatcher.anyInsn(25), InsnMatcher.methodInsn(182, "hellfirepvp/astralsorcery/common/util/data/Vector3", "getX", "()D"), InsnMatcher.anyInsn(25), InsnMatcher.methodInsn(182, "hellfirepvp/astralsorcery/common/util/data/Vector3", "getY", "()D"), InsnMatcher.anyInsn(25), InsnMatcher.methodInsn(182, "hellfirepvp/astralsorcery/common/util/data/Vector3", "getZ", "()D"), InsnMatcher.anyInsn(25), InsnMatcher.methodInsn(184, "hellfirepvp/astralsorcery/common/util/ItemUtils", "dropItem", "(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)Lnet/minecraft/entity/item/EntityItem;"));

        public MethodRewriterUpdate(int api, MethodVisitor downstream, int access, String name, String desc, String signature, String[] exceptions) {
            super(api, downstream, access, name, desc, signature, exceptions);
        }

        @Override
        protected void rewrite(MethodNode method) {
            InsnMatcher.Match mCraftingCheck = MATCH_CRAFTING_CHECK.find(method.instructions.getFirst());
            if (mCraftingCheck == null) {
                TconEvoCoreMod.LOGGER.warn("Failed to find attunement completion check!");
                return;
            }
            InsnMatcher.Match mThrower = MATCH_GET_THROWER.find(mCraftingCheck.tail);
            if (mThrower == null) {
                TconEvoCoreMod.LOGGER.warn("Failed to find attunement item thrower check!");
                return;
            }
            InsnMatcher.Match mDrop = MATCH_DROP_ITEM.find(mThrower.tail);
            if (mDrop == null) {
                TconEvoCoreMod.LOGGER.warn("Failed to find attunement result drop!");
                return;
            }
            int resultVar = ((VarInsnNode)Objects.requireNonNull(MethodRewriterUpdate.walkForwards((AbstractInsnNode)mDrop.start, (int)8))).var;
            LabelNode successLabel = new LabelNode();
            method.instructions.insertBefore(mCraftingCheck.tail, MethodRewriterUpdate.getInjectedCode(resultVar, successLabel));
            method.instructions.insertBefore(mThrower.start, (AbstractInsnNode)successLabel);
        }

        private static InsnList getInjectedCode(int resultVar, LabelNode successLabel) {
            return new InsnWriter().aload(0).getfield(TransformAstralAttunement.TYPE_ATT_ALTAR, "activeEntity", "Lnet/minecraft/entity/Entity;").checkcast("net/minecraft/entity/item/EntityItem").invokevirtual("net/minecraft/entity/item/EntityItem", "func_92059_d", "()Lnet/minecraft/item/ItemStack;").aload(0).getfield(TransformAstralAttunement.TYPE_ATT_ALTAR, "activeFound", "Lhellfirepvp/astralsorcery/common/constellation/IConstellation;").invokestatic("xyz/phanta/tconevo/integration/astralsorcery/AttunementGenerifyCoreHooks", "tryAttuneItem", "(Lnet/minecraft/item/ItemStack;Lhellfirepvp/astralsorcery/common/constellation/IConstellation;)Lnet/minecraft/item/ItemStack;").astore(resultVar).aload(resultVar).ifnonnull(successLabel).asList();
        }
    }

    private static class ClassTransformerTileAttunementAltar
    extends ClassVisitor {
        public ClassTransformerTileAttunementAltar(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("func_73660_a") || name.equals("update")) {
                return new MethodRewriterUpdate(this.api, super.visitMethod(access, name, desc, signature, exceptions), access, name, desc, signature, exceptions);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

