/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.transform;

import java.util.function.Consumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import xyz.phanta.tconevo.coremod.TconEvoClassTransformer;

public class TransformCustomMaterialRender
implements TconEvoClassTransformer.Transform {
    private static final String CLASS_MATERIAL_MODEL_LOADER = "slimeknights.tconstruct.library.client.model.MaterialModelLoader";
    private static final String CLASS_TOOL_MODEL_LOADER = "slimeknights.tconstruct.library.client.model.ToolModelLoader";
    private static final String TYPE_MATERIAL_MODEL = "slimeknights/tconstruct/library/client/model/MaterialModel";
    private static final String TYPE_TOOL_MODEL = "slimeknights/tconstruct/library/client/model/ToolModel";

    @Override
    public String getName() {
        return "Custom Material Render";
    }

    @Override
    public void getClasses(Consumer<String> collector) {
        collector.accept(CLASS_MATERIAL_MODEL_LOADER);
        collector.accept(CLASS_TOOL_MODEL_LOADER);
    }

    @Override
    public ClassVisitor createTransformer(String className, int apiVersion, ClassVisitor downstream) {
        return new ClassTransformerModelLoader(apiVersion, downstream, CLASS_MATERIAL_MODEL_LOADER.equals(className));
    }

    private static class MethodTransformerLoadModel
    extends MethodVisitor {
        private final boolean renderHalo;
        private boolean dropDup = false;

        MethodTransformerLoadModel(int api, MethodVisitor mv, boolean renderHalo) {
            super(api, mv);
            this.renderHalo = renderHalo;
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187 && (type.equals(TransformCustomMaterialRender.TYPE_MATERIAL_MODEL) || type.equals(TransformCustomMaterialRender.TYPE_TOOL_MODEL))) {
                this.dropDup = true;
            } else {
                super.visitTypeInsn(opcode, type);
            }
        }

        public void visitInsn(int opcode) {
            if (this.dropDup && opcode == 89) {
                this.dropDup = false;
            } else {
                super.visitInsn(opcode);
            }
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            this.dropDup = false;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 183 && name.equals("<init>")) {
                switch (owner) {
                    case "slimeknights/tconstruct/library/client/model/MaterialModel": {
                        super.visitInsn(this.renderHalo ? 4 : 3);
                        switch (desc) {
                            case "(Lcom/google/common/collect/ImmutableList;)V": {
                                super.visitMethodInsn(184, "xyz/phanta/tconevo/client/handler/CustomModelRenderCoreHooks", "createMaterialModel", "(Lcom/google/common/collect/ImmutableList;Z)Lslimeknights/tconstruct/library/client/model/MaterialModel;", false);
                                break;
                            }
                            case "(Lcom/google/common/collect/ImmutableList;II)V": {
                                super.visitMethodInsn(184, "xyz/phanta/tconevo/client/handler/CustomModelRenderCoreHooks", "createMaterialModel", "(Lcom/google/common/collect/ImmutableList;IIZ)Lslimeknights/tconstruct/library/client/model/MaterialModel;", false);
                            }
                        }
                        return;
                    }
                    case "slimeknights/tconstruct/library/client/model/ToolModel": {
                        super.visitMethodInsn(184, "xyz/phanta/tconevo/client/handler/CustomModelRenderCoreHooks", "createToolModel", "(Lcom/google/common/collect/ImmutableList;Ljava/util/List;Ljava/util/List;[Ljava/lang/Float;Lslimeknights/tconstruct/library/client/model/ModifierModel;Lcom/google/common/collect/ImmutableMap;Lcom/google/common/collect/ImmutableList;Lslimeknights/tconstruct/library/client/model/format/AmmoPosition;)Lslimeknights/tconstruct/library/client/model/ToolModel;", false);
                        return;
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private static class ClassTransformerModelLoader
    extends ClassVisitor {
        private final boolean renderHalo;

        ClassTransformerModelLoader(int api, ClassVisitor cv, boolean renderHalo) {
            super(api, cv);
            this.renderHalo = renderHalo;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("loadModel") && desc.equals("(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraftforge/client/model/IModel;")) {
                return new MethodTransformerLoadModel(this.api, super.visitMethod(access, name, desc, signature, exceptions), this.renderHalo);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

