/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.transform;

import java.util.function.Consumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import xyz.phanta.tconevo.coremod.TconEvoClassTransformer;
import xyz.phanta.tconevo.coremod.util.VarTracker;

public class TransformFixArmourDamage
implements TconEvoClassTransformer.Transform {
    @Override
    public String getName() {
        return "Fix Armour Damage";
    }

    @Override
    public int getWriteFlags() {
        return 3;
    }

    @Override
    public void getClasses(Consumer<String> collector) {
        collector.accept("net.minecraftforge.common.ISpecialArmor$ArmorProperties");
    }

    @Override
    public ClassVisitor createTransformer(String className, int apiVersion, ClassVisitor downstream) {
        return new ClassTransformerArmorProperties(apiVersion, downstream);
    }

    private static class MethodTransformerApplyArmor
    extends MethodVisitor {
        private final VarTracker vars = new VarTracker(5);

        MethodTransformerApplyArmor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, this.vars.map(opcode, var));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 182 && (name.equals("func_77972_a") || name.equals("damageItem")) && owner.equals("net/minecraft/item/ItemStack") && desc.equals("(ILnet/minecraft/entity/EntityLivingBase;)V")) {
                int varItemStack = this.vars.create();
                int varDamage = this.vars.create();
                int varWielder = this.vars.create();
                super.visitVarInsn(58, varWielder);
                super.visitVarInsn(54, varDamage);
                super.visitVarInsn(58, varItemStack);
                super.visitVarInsn(25, varItemStack);
                super.visitVarInsn(21, varDamage);
                super.visitVarInsn(25, varWielder);
                super.visitMethodInsn(184, "xyz/phanta/tconevo/handler/ArmourDamageCoreHooks", "shouldDamageItem", "(Lnet/minecraft/item/ItemStack;ILnet/minecraft/entity/EntityLivingBase;)Z", false);
                Label cancelDamage = new Label();
                super.visitJumpInsn(153, cancelDamage);
                super.visitVarInsn(25, varItemStack);
                super.visitVarInsn(21, varDamage);
                super.visitVarInsn(25, varWielder);
                super.visitMethodInsn(182, "net/minecraft/item/ItemStack", name, "(ILnet/minecraft/entity/EntityLivingBase;)V", false);
                super.visitLabel(cancelDamage);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class ClassTransformerArmorProperties
    extends ClassVisitor {
        ClassTransformerArmorProperties(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("applyArmor") && desc.equals("(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/util/NonNullList;Lnet/minecraft/util/DamageSource;D)F")) {
                return new MethodTransformerApplyArmor(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

