/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.transform;

import java.util.function.Consumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import xyz.phanta.tconevo.coremod.TconEvoClassTransformer;

public class TransformThaumInfusionEnchantment
implements TconEvoClassTransformer.Transform {
    private static final String TYPE_INF_ENCH_RECIPE = "thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe";
    private static final String TYPE_TOOL_EVENTS = "thaumcraft.common.lib.events.ToolEvents";

    @Override
    public String getName() {
        return "Thaumcraft Infusion Enchantment";
    }

    @Override
    public void getClasses(Consumer<String> collector) {
        collector.accept(TYPE_INF_ENCH_RECIPE);
        collector.accept(TYPE_TOOL_EVENTS);
    }

    @Override
    public ClassVisitor createTransformer(String className, int apiVersion, ClassVisitor downstream) {
        switch (className) {
            case "thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe": {
                return new ClassTransformerInfusionEnchantmentRecipe(apiVersion, downstream);
            }
            case "thaumcraft.common.lib.events.ToolEvents": {
                return new ClassTransformerToolEvents(apiVersion, downstream);
            }
        }
        return downstream;
    }

    private static class MethodTransformerToolEvents
    extends MethodVisitor {
        private final boolean overwriteIsToolEffective;

        public MethodTransformerToolEvents(int api, MethodVisitor mv, String methodName) {
            super(api, mv);
            this.overwriteIsToolEffective = methodName.equals("harvestBlockEvent");
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (name.equals("damageItem") && owner.equals("net/minecraft/item/ItemStack")) {
                super.visitMethodInsn(184, "xyz/phanta/tconevo/handler/TinkerToolPropCoreHooks", "damageItem", "(Lnet/minecraft/item/ItemStack;ILnet/minecraft/entity/EntityLivingBase;)V", false);
            } else if (this.overwriteIsToolEffective && name.equals("isToolEffective") && owner.equals("net/minecraftforge/common/ForgeHooks")) {
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(182, "net/minecraftforge/event/world/BlockEvent", "getState", "()Lnet/minecraft/block/state/IBlockState;", false);
                super.visitMethodInsn(184, "xyz/phanta/tconevo/handler/TinkerToolPropCoreHooks", "isToolEffective", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;Lnet/minecraft/block/state/IBlockState;)Z", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class ClassTransformerToolEvents
    extends ClassVisitor {
        public ClassTransformerToolEvents(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodTransformerToolEvents(this.api, super.visitMethod(access, name, desc, signature, exceptions), name);
        }
    }

    private static class MethodTransformerMatches
    extends MethodVisitor {
        private boolean seenInstanceOf = false;

        public MethodTransformerMatches(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (type.equals("net/minecraft/item/ItemTool")) {
                switch (opcode) {
                    case 193: {
                        this.seenInstanceOf = true;
                        super.visitInsn(87);
                        super.visitInsn(4);
                        return;
                    }
                    case 192: {
                        if (!this.seenInstanceOf) break;
                        return;
                    }
                }
            } else {
                this.seenInstanceOf = false;
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (name.equals("getToolClasses") && owner.equals("net/minecraft/item/ItemTool")) {
                super.visitMethodInsn(182, "net/minecraft/item/Item", "getToolClasses", "(Lnet/minecraft/item/ItemStack;)Ljava/util/Set;", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class ClassTransformerInfusionEnchantmentRecipe
    extends ClassVisitor {
        public ClassTransformerInfusionEnchantmentRecipe(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("matches")) {
                return new MethodTransformerMatches(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

