/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.entity;

import io.github.phantamanta44.libnine.util.format.TextFormatUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.events.ProjectileEvent;

public class EntityMagicMissile
extends EntityProjectileBase {
    public static final DataParameter<Integer> COLOUR = EntityDataManager.func_187226_a(EntityMagicMissile.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMagicMissile(World world, EntityLivingBase shooter, Vec3d dir, float velocity, ItemStack weapon) {
        super(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
        this.field_70250_c = shooter;
        this.bounceOnNoDamage = false;
        this.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, Math.max(velocity, 0.05f), 0.0f);
        this.tinkerProjectile.setItemStack(weapon);
        this.tinkerProjectile.setLaunchingStack(weapon);
        this.tinkerProjectile.setPower(1.0f);
    }

    public EntityMagicMissile(World world) {
        super(world);
    }

    protected void init() {
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOUR, (Object)0);
    }

    public int getColour() {
        return (Integer)this.field_70180_af.func_187225_a(COLOUR);
    }

    public void setColour(int colour) {
        this.field_70180_af.func_187227_b(COLOUR, (Object)colour);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 32) {
            this.onHitSomething();
        }
    }

    public double getGravity() {
        return 0.0;
    }

    public void onHitBlock(RayTraceResult trace) {
        this.field_70254_i = true;
        BlockPos hitBlockPos = trace.func_178782_a();
        IBlockState hitState = this.field_70170_p.func_180495_p(hitBlockPos);
        ProjectileEvent.OnHitBlock.fireEvent((EntityProjectileBase)this, (float)this.getSpeed(), (BlockPos)hitBlockPos, (IBlockState)hitState);
        if (hitState.func_185904_a() != Material.field_151579_a) {
            hitState.func_177230_c().func_180634_a(this.field_70170_p, hitBlockPos, hitState, (Entity)this);
        }
        this.onHitSomething();
    }

    protected void onEntityHit(Entity entityHit) {
        this.onHitSomething();
    }

    protected void onHitSomething() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191248_br, SoundCategory.PLAYERS, 0.5f, 1.5f + this.field_70146_Z.nextFloat() * 0.5f, false);
            int colour = this.getColour();
            float b = TextFormatUtils.getComponent((int)colour, (int)0);
            float g = TextFormatUtils.getComponent((int)colour, (int)1);
            float r = TextFormatUtils.getComponent((int)colour, (int)2);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.2, this.field_70163_u + 0.25 + this.field_70146_Z.nextGaussian() * 0.2, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.2, r != 0.0f ? (double)r : (double)1.0E-6f, (double)g, (double)b, new int[0]);
            }
        }
        this.func_70106_y();
    }

    protected void playHitEntitySound() {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

