/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.handler;

import io.github.phantamanta44.libnine.util.helper.OptUtils;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xyz.phanta.tconevo.capability.EnergyShield;
import xyz.phanta.tconevo.init.TconEvoCaps;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;

public class EnergyShieldHandler {
    private final Set<UUID> inHitHandler = new HashSet<UUID>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityAttacked(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        UUID playerId = player.func_110124_au();
        if (this.inHitHandler.contains(playerId) || !DraconicHooks.INSTANCE.isShieldEnabled(player)) {
            return;
        }
        this.inHitHandler.add(playerId);
        try {
            float damage = event.getAmount();
            DamageSource dmgSrc = event.getSource();
            if (damage == Float.MAX_VALUE && dmgSrc.func_76363_c() && dmgSrc.func_76357_e()) {
                return;
            }
            List<EnergyShield> shields = EnergyShieldHandler.collectArmourShields(player.field_71071_by);
            float totalShieldPoints = 0.0f;
            for (EnergyShield shield : shields) {
                totalShieldPoints += shield.getShieldPoints();
            }
            if (totalShieldPoints <= 0.0f) {
                return;
            }
            Entity attackerEntity = dmgSrc.func_76346_g();
            float bonusEntropyCost = 0.0f;
            if (attackerEntity instanceof EntityPlayer) {
                EntityPlayer attacker = (EntityPlayer)attackerEntity;
                IPair<Float, Float> newDamage = DraconicHooks.INSTANCE.applyShieldDamageModifiers(player, attacker, totalShieldPoints, damage);
                if (newDamage != null) {
                    damage = ((Float)newDamage.getA()).floatValue();
                    bonusEntropyCost = ((Float)newDamage.getB()).floatValue();
                } else if (dmgSrc.func_76363_c() || dmgSrc.func_76357_e()) {
                    damage *= 2.0f;
                }
            }
            event.setCanceled(true);
            if ((float)player.field_70172_ad <= (float)player.field_70771_an - 4.0f) {
                float newEntropy = 0.0f;
                float totalShieldCapacity = 0.0f;
                for (EnergyShield shield : shields) {
                    newEntropy += shield.getEntropy();
                    totalShieldCapacity += shield.getShieldCapacity();
                }
                newEntropy = Math.min(newEntropy / (float)shields.size() + 1.0f + damage / 20.0f + bonusEntropyCost, 100.0f);
                float damageAbsorbedTotal = 0.0f;
                float remainingShieldTotal = 0.0f;
                for (EnergyShield shield : shields) {
                    float damageAbsorbed;
                    float shieldPoints = shield.getShieldPoints();
                    if (!(shieldPoints > 0.0f) || !((damageAbsorbed = Math.min(damage * (shieldPoints / totalShieldPoints), shieldPoints)) > 0.0f)) continue;
                    damageAbsorbedTotal += damageAbsorbed;
                    float remainingShield = shieldPoints - damageAbsorbed;
                    shield.setShield(remainingShield);
                    remainingShieldTotal += remainingShield;
                    shield.setEntropy(newEntropy);
                    shield.onDamageAbsorbed(damageAbsorbed, player);
                }
                DraconicHooks.INSTANCE.playShieldHitEffect(player, remainingShieldTotal / totalShieldCapacity);
                if (remainingShieldTotal > 0.0f) {
                    player.field_70172_ad = 20;
                } else if (damageAbsorbedTotal < damage) {
                    player.func_70097_a(dmgSrc, damage - damageAbsorbedTotal);
                }
            }
        }
        finally {
            this.inHitHandler.remove(playerId);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.field_72995_K) {
            return;
        }
        for (EnergyShield shield : EnergyShieldHandler.collectArmourShields(event.player.field_71071_by)) {
            float shieldPoints = shield.getShieldPoints();
            float shieldCap = shield.getShieldCapacity();
            float entropy = shield.getEntropy();
            float recovPoints = Math.min(shieldCap - shieldPoints, shieldCap / 60.0f) * (1.0f - entropy / 100.0f);
            if (recovPoints > 0.0f) {
                int cost = (int)Math.ceil(recovPoints * (float)shield.getShieldCost());
                shield.setShield(shieldPoints + recovPoints * (float)shield.extractEnergy(cost, false) / (float)cost);
            }
            if (!(entropy > 0.0f)) continue;
            shield.setEntropy(entropy - shield.getShieldRecovery() / 100.0f);
        }
    }

    public static List<EnergyShield> collectArmourShields(InventoryPlayer player) {
        ArrayList<EnergyShield> shields = new ArrayList<EnergyShield>();
        for (ItemStack stack : player.field_70460_b) {
            OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.ENERGY_SHIELD).ifPresent(shields::add);
        }
        return shields;
    }
}

