/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.handler;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xyz.phanta.tconevo.init.TconEvoEntityAttrs;
import xyz.phanta.tconevo.util.DamageUtils;

public class EntityAttributeHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityAttacked(LivingAttackEvent event) {
        EntityLivingBase victim = event.getEntityLiving();
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        DamageSource dmgSrc = event.getSource();
        float amount = event.getAmount();
        if (dmgSrc.func_76364_f() == null || dmgSrc.func_151517_h() || DamageUtils.isPureDamage(dmgSrc, amount)) {
            return;
        }
        double odds = victim.func_110148_a(TconEvoEntityAttrs.EVASION_CHANCE).func_111126_e() - 1.0;
        if (odds > 0.0 && (odds >= 1.0 || victim.field_70170_p.field_73012_v.nextDouble() <= odds)) {
            event.setCanceled(true);
            victim.field_110153_bc = amount;
            victim.field_70172_ad = victim.field_70771_an;
            victim.field_70170_p.func_184148_a(null, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.4f + 0.3f * victim.field_70170_p.field_73012_v.nextFloat());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityHurt(LivingHurtEvent event) {
        float damage = event.getAmount();
        if (damage <= 0.0f || DamageUtils.isPureDamage(event.getSource(), damage)) {
            return;
        }
        double multiplier = event.getEntityLiving().func_110148_a(TconEvoEntityAttrs.DAMAGE_TAKEN).func_111126_e();
        if (multiplier != 1.0) {
            event.setAmount(Math.max(damage * (float)multiplier, 0.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityHeal(LivingHealEvent event) {
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        double multiplier = event.getEntityLiving().func_110148_a(TconEvoEntityAttrs.HEALING_RECEIVED).func_111126_e();
        if (multiplier != 1.0) {
            event.setAmount(Math.max(amount * (float)multiplier, 0.0f));
        }
    }
}

