/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.handler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerStateHandler {
    private final Set<UUID> attackingPlayers = new HashSet<UUID>();
    private final Map<UUID, VelocityTracker> velocities = new WeakHashMap<UUID, VelocityTracker>();

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            this.attackingPlayers.add(event.getEntityPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.attackingPlayers.clear();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            VelocityTracker velTracker = this.velocities.get(event.player.func_110124_au());
            if (velTracker == null) {
                this.velocities.put(event.player.func_110124_au(), new VelocityTracker((Entity)event.player));
            } else {
                velTracker.update((Entity)event.player);
            }
        }
    }

    public boolean isPlayerAttacking(EntityPlayer player) {
        return this.attackingPlayers.contains(player.func_110124_au());
    }

    public Vec3d getPlayerVelocity(EntityPlayer player) {
        VelocityTracker velTracker = this.velocities.get(player.func_110124_au());
        return velTracker != null ? velTracker.getVelocity() : Vec3d.field_186680_a;
    }

    private static class VelocityTracker {
        private double posX;
        private double posY;
        private double posZ;
        private Vec3d velocity = Vec3d.field_186680_a;

        VelocityTracker(Entity entity) {
            this.posX = entity.field_70165_t;
            this.posY = entity.field_70163_u;
            this.posZ = entity.field_70161_v;
        }

        public void update(Entity entity) {
            this.velocity = new Vec3d(entity.field_70165_t - this.posX, entity.field_70163_u - this.posY, entity.field_70161_v - this.posZ);
            this.posX = entity.field_70165_t;
            this.posY = entity.field_70163_u;
            this.posZ = entity.field_70161_v;
        }

        public Vec3d getVelocity() {
            return this.velocity;
        }
    }
}

