/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ToolCapabilityHandler {
    private final ResourceLocation TINKERS_EVO_CAP = new ResourceLocation("tconevo", "multi_capability");
    private final Map<String, Function<ItemStack, ICapabilityProvider>> modifierCaps = new HashMap<String, Function<ItemStack, ICapabilityProvider>>();

    public void addModifierCap(Modifier mod, Function<ItemStack, ICapabilityProvider> capFactory) {
        this.addModifierCap(mod.getIdentifier(), capFactory);
    }

    public void addModifierCap(String modifierId, Function<ItemStack, ICapabilityProvider> capFactory) {
        this.modifierCaps.put(modifierId, capFactory);
    }

    @SubscribeEvent
    public void onItemCapAttach(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_77973_b() instanceof ITinkerable) {
            event.addCapability(this.TINKERS_EVO_CAP, (ICapabilityProvider)new TconEvoCapProvider(stack, this.modifierCaps));
        }
    }

    private static class TconEvoCapProvider
    implements ICapabilityProvider {
        private final ItemStack stack;
        private final Map<String, Function<ItemStack, ICapabilityProvider>> capFactories;
        private final Map<String, Optional<ICapabilityProvider>> capCache = new HashMap<String, Optional<ICapabilityProvider>>();

        public TconEvoCapProvider(ItemStack stack, Map<String, Function<ItemStack, ICapabilityProvider>> capFactories) {
            this.stack = stack;
            this.capFactories = capFactories;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            for (NBTBase tag : TagUtil.getModifiersTagList((ItemStack)this.stack)) {
                if (!(tag instanceof NBTTagCompound)) continue;
                String modId = ((NBTTagCompound)tag).func_74779_i("identifier");
                ICapabilityProvider capProvider = null;
                Optional<ICapabilityProvider> capProviderOpt = this.capCache.get(modId);
                if (capProviderOpt != null) {
                    if (capProviderOpt.isPresent()) {
                        capProvider = capProviderOpt.get();
                    }
                } else {
                    Function<ItemStack, ICapabilityProvider> capFactory = this.capFactories.get(modId);
                    if (capFactory != null) {
                        capProvider = capFactory.apply(this.stack);
                        this.capCache.put(modId, Optional.of(capProvider));
                    } else {
                        this.capCache.put(modId, Optional.empty());
                    }
                }
                if (capProvider == null || !capProvider.hasCapability(capability, facing)) continue;
                return (T)Objects.requireNonNull(capProvider.getCapability(capability, facing));
            }
            return null;
        }
    }
}

