/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.advsolars;

import com.chocohead.advsolar.tiles.TileEntityAdvancedSolar;
import com.chocohead.advsolar.tiles.TileEntityHybridSolar;
import com.chocohead.advsolar.tiles.TileEntityQuantumSolar;
import com.chocohead.advsolar.tiles.TileEntityUltimateHybridSolar;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import xyz.phanta.tconevo.integration.advsolars.AdvSolarHooks;
import xyz.phanta.tconevo.trait.ModifierPhotovoltaic;

public class AdvSolarHooksImpl
implements AdvSolarHooks {
    @Nullable
    private Block machineBlock;

    @Override
    public void onInit(FMLInitializationEvent event) {
        this.machineBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("advanced_solar_panels", "machines"));
        Item craftingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("advanced_solar_panels", "crafting"));
        if (craftingItem != null) {
            OreDictionary.registerOre((String)"itemSunnarium", (ItemStack)new ItemStack(craftingItem, 1, 0));
            OreDictionary.registerOre((String)"nuggetSunnarium", (ItemStack)new ItemStack(craftingItem, 1, 1));
        }
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        this.getItemAdvancedSolar().ifPresent(s -> ModifierPhotovoltaic.registerSolarItem(s, (int)Math.round((double)TileEntityAdvancedSolar.settings.dayPower * 2.5 * 20.0)));
        this.getItemHybridSolar().ifPresent(s -> ModifierPhotovoltaic.registerSolarItem(s, (int)Math.round((double)TileEntityHybridSolar.settings.dayPower * 2.5 * 20.0)));
        this.getItemUltimateSolar().ifPresent(s -> ModifierPhotovoltaic.registerSolarItem(s, (int)Math.round((double)TileEntityUltimateHybridSolar.settings.dayPower * 2.5 * 20.0)));
        this.getItemQuantumSolar().ifPresent(s -> ModifierPhotovoltaic.registerSolarItem(s, (int)Math.round((double)TileEntityQuantumSolar.settings.dayPower * 2.5 * 20.0)));
    }

    @Override
    public Optional<ItemStack> getItemAdvancedSolar() {
        return Optional.ofNullable(this.newMachineStack(2));
    }

    @Override
    public Optional<ItemStack> getItemHybridSolar() {
        return Optional.ofNullable(this.newMachineStack(3));
    }

    @Override
    public Optional<ItemStack> getItemUltimateSolar() {
        return Optional.ofNullable(this.newMachineStack(4));
    }

    @Override
    public Optional<ItemStack> getItemQuantumSolar() {
        return Optional.ofNullable(this.newMachineStack(5));
    }

    @Nullable
    private ItemStack newMachineStack(int meta) {
        return this.machineBlock != null ? new ItemStack(this.machineBlock, 1, meta) : null;
    }
}

