/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.avaritia.client;

import codechicken.lib.render.item.IItemRenderer;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import morph.avaritia.client.render.item.WrappedItemRenderer;
import morph.avaritia.client.render.shader.CosmicShaderHelper;
import morph.avaritia.init.AvaritiaTextures;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import slimeknights.mantle.client.model.BakedWrapper;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import xyz.phanta.tconevo.client.render.material.CosmicMaterialRenderInfo;
import xyz.phanta.tconevo.client.util.CodeChickenModel;
import xyz.phanta.tconevo.client.util.DelegateModelCache;
import xyz.phanta.tconevo.client.util.DelegatingModel;
import xyz.phanta.tconevo.client.util.TconReflectClient;
import xyz.phanta.tconevo.init.TconEvoMaterials;
import xyz.phanta.tconevo.integration.avaritia.client.AvaritiaRenderUtils;

class AvaritiaMaterialModel
extends MaterialModel {
    private final boolean renderHalo;

    AvaritiaMaterialModel(ImmutableList<ResourceLocation> textures, int offsetX, int offsetY, boolean renderHalo) {
        super(textures, offsetX, offsetY);
        this.renderHalo = renderHalo;
    }

    public BakedMaterialModel bakeIt(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        BakedMaterialModel delegate = super.bakeIt(state, format, bakedTextureGetter);
        return this.renderHalo ? new BakedAvaritiaMaterialModel.WithHalo((IBakedModel)delegate, (IModelState)new SimpleModelState(TconReflectClient.getTransforms((BakedWrapper.Perspective)delegate))) : new BakedAvaritiaMaterialModel.WithoutHalo((IBakedModel)delegate, (IModelState)new SimpleModelState(TconReflectClient.getTransforms((BakedWrapper.Perspective)delegate)));
    }

    public static abstract class BakedAvaritiaMaterialModel
    extends BakedMaterialModel
    implements DelegatingModel<IBakedModel, BakedAvaritiaMaterialModel>,
    IItemRenderer,
    CodeChickenModel {
        protected final IModelState state;
        protected final DelegateModelCache<IBakedModel, BakedAvaritiaMaterialModel> delegateCache;

        BakedAvaritiaMaterialModel(IBakedModel parent, IModelState state) {
            super(parent, PerspectiveMapWrapper.getTransforms((IModelState)state));
            this.state = state;
            this.delegateCache = new DelegateModelCache.Overriding<BakedAvaritiaMaterialModel>(this);
        }

        protected BakedAvaritiaMaterialModel(IBakedModel parent, IModelState state, DelegateModelCache<IBakedModel, BakedAvaritiaMaterialModel> delegateCache) {
            super(parent, PerspectiveMapWrapper.getTransforms((IModelState)state));
            this.state = state;
            this.delegateCache = delegateCache;
        }

        @Override
        public IBakedModel getParentModel() {
            return this.parent;
        }

        public IModelState getTransforms() {
            return this.state;
        }

        public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
            Item item = stack.func_77973_b();
            if (item instanceof IMaterialItem) {
                Material mat = ((IMaterialItem)item).getMaterial(stack);
                this.renderUnderlay(stack, transformType, mat);
                WrappedItemRenderer.renderModel((IBakedModel)this.parent, (ItemStack)stack);
                this.renderOverlay(stack, transformType, mat);
            } else {
                WrappedItemRenderer.renderModel((IBakedModel)this.parent, (ItemStack)stack);
            }
        }

        public void renderUnderlay(ItemStack stack, ItemCameraTransforms.TransformType transType, Material mat) {
        }

        public void renderOverlay(ItemStack stack, ItemCameraTransforms.TransformType transType, Material mat) {
        }

        public IBakedModel getModelByIdentifier(String identifier) {
            return this.delegateCache.getWrappedDelegate(this.parent instanceof BakedMaterialModel ? ((BakedMaterialModel)this.parent).getModelByIdentifier(identifier) : this.parent);
        }

        public ItemOverrideList func_188617_f() {
            return this.delegateCache;
        }

        static class WithoutHalo
        extends BakedAvaritiaMaterialModel {
            WithoutHalo(IBakedModel parent, IModelState state) {
                super(parent, state);
            }

            private WithoutHalo(IBakedModel parent, IModelState state, DelegateModelCache<IBakedModel, BakedAvaritiaMaterialModel> delegateCache) {
                super(parent, state, delegateCache);
            }

            @Override
            public BakedAvaritiaMaterialModel wrapDelegate(IBakedModel delegateKey) {
                return new WithoutHalo(delegateKey, this.state, this.delegateCache);
            }

            @Override
            public void renderOverlay(ItemStack stack, ItemCameraTransforms.TransformType transType, Material mat) {
                TextureAtlasSprite maskSprite;
                if (mat == TconEvoMaterials.INFINITY_METAL && (maskSprite = WithoutHalo.getCosmicMask(this.parent)) != null) {
                    this.handleCosmicLighting(transType);
                    if (transType == ItemCameraTransforms.TransformType.GUI) {
                        AvaritiaRenderUtils.renderCosmicOverlayInGui(maskSprite, stack, 1.0f);
                    } else {
                        AvaritiaRenderUtils.renderCosmicOverlayInWorld(maskSprite, stack, 1.0f);
                    }
                }
            }

            @Nullable
            private static TextureAtlasSprite getCosmicMask(IBakedModel itemModel) {
                TextureAtlasSprite baseSprite = itemModel.func_177554_e();
                if (baseSprite instanceof CosmicMaterialRenderInfo.CosmicTexture) {
                    return ((CosmicMaterialRenderInfo.CosmicTexture)baseSprite).getMaskTexture();
                }
                return null;
            }

            private void handleCosmicLighting(ItemCameraTransforms.TransformType transType) {
                switch (transType) {
                    case GROUND: 
                    case THIRD_PERSON_LEFT_HAND: 
                    case THIRD_PERSON_RIGHT_HAND: 
                    case FIRST_PERSON_LEFT_HAND: 
                    case FIRST_PERSON_RIGHT_HAND: 
                    case HEAD: {
                        BlockPos entityPos = this.delegateCache.getCachedEntityPos();
                        if (entityPos == null) break;
                        CosmicShaderHelper.setLightFromLocation((World)this.delegateCache.getCachedWorld(), (BlockPos)entityPos);
                        return;
                    }
                    case GUI: {
                        CosmicShaderHelper.setLightLevel((float)1.2f);
                        return;
                    }
                }
                CosmicShaderHelper.setLightLevel((float)1.0f);
            }
        }

        static class WithHalo
        extends BakedAvaritiaMaterialModel {
            WithHalo(IBakedModel parent, IModelState state) {
                super(parent, state);
            }

            protected WithHalo(IBakedModel parent, IModelState state, DelegateModelCache<IBakedModel, BakedAvaritiaMaterialModel> delegateCache) {
                super(parent, state, delegateCache);
            }

            @Override
            public BakedAvaritiaMaterialModel wrapDelegate(IBakedModel delegateKey) {
                return new WithHalo(delegateKey, this.state, this.delegateCache);
            }

            @Override
            public void renderUnderlay(ItemStack stack, ItemCameraTransforms.TransformType transType, Material mat) {
                if (transType == ItemCameraTransforms.TransformType.GUI) {
                    if (mat == TconEvoMaterials.NEUTRONIUM) {
                        AvaritiaRenderUtils.renderHaloInGui(this.parent, stack, AvaritiaTextures.HALO_NOISE, 0.4, -1711276033, false);
                    } else if (mat == TconEvoMaterials.INFINITY_METAL) {
                        AvaritiaRenderUtils.renderHaloInGui(this.parent, stack, AvaritiaTextures.HALO, 0.5, -16777216, true);
                    }
                }
            }
        }
    }
}

