/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.avaritia.client;

import codechicken.lib.colour.Colour;
import codechicken.lib.model.ItemQuadBakery;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.util.TransformUtils;
import com.google.common.collect.ImmutableList;
import io.github.phantamanta44.libnine.util.helper.MirrorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import morph.avaritia.client.render.item.CosmicItemRender;
import morph.avaritia.client.render.item.WrappedItemRenderer;
import morph.avaritia.client.render.shader.CosmicShaderHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.model.IModelState;

public class AvaritiaRenderUtils {
    private static final Random rand = new Random();
    private static final HashMap<TextureAtlasSprite, IBakedModel> spriteQuadCache = (HashMap)MirrorUtils.reflectField(CosmicItemRender.class, (String)"spriteQuadCache").get(null);

    public static void renderHaloInGui(IBakedModel parentModel, ItemStack stack, TextureAtlasSprite haloSprite, double size, int colour, boolean pulse) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        Colour.glColourARGB((int)colour);
        double minPos = 0.0 - size;
        double maxPos = 1.0 + size;
        float minU = haloSprite.func_94209_e();
        float maxU = haloSprite.func_94212_f();
        float minV = haloSprite.func_94206_g();
        float maxV = haloSprite.func_94210_h();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(maxPos, maxPos, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buf.func_181662_b(minPos, maxPos, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        buf.func_181662_b(minPos, minPos, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buf.func_181662_b(maxPos, minPos, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        tess.func_78381_a();
        if (pulse) {
            GlStateManager.func_179094_E();
            double scale = rand.nextDouble() * 0.15 + 0.95;
            double trans = (1.0 - scale) / 2.0;
            GlStateManager.func_179137_b((double)trans, (double)trans, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0001);
            WrappedItemRenderer.renderModel((IBakedModel)parentModel, (ItemStack)stack, (float)0.6f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void renderCosmicOverlayInWorld(TextureAtlasSprite maskSprite, ItemStack stack, float opacity) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CosmicShaderHelper.cosmicOpacity = opacity;
        CosmicShaderHelper.useShader();
        WrappedItemRenderer.renderModel((IBakedModel)AvaritiaRenderUtils.getModelForMaskSprite(maskSprite), (ItemStack)stack);
        CosmicShaderHelper.releaseShader();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void renderCosmicOverlayInGui(TextureAtlasSprite maskSprite, ItemStack stack, float opacity) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CosmicShaderHelper.cosmicOpacity = opacity;
        CosmicShaderHelper.inventoryRender = true;
        CosmicShaderHelper.useShader();
        WrappedItemRenderer.renderModel((IBakedModel)AvaritiaRenderUtils.getModelForMaskSprite(maskSprite), (ItemStack)stack);
        CosmicShaderHelper.releaseShader();
        CosmicShaderHelper.inventoryRender = false;
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179091_B();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static IBakedModel getModelForMaskSprite(TextureAtlasSprite sprite) {
        return spriteQuadCache.computeIfAbsent(sprite, s -> new PerspectiveAwareBakedModel(ItemQuadBakery.bakeItem((List)ImmutableList.of((Object)s)), (IModelState)TransformUtils.DEFAULT_ITEM, new ModelProperties(true, false)));
    }
}

