/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.avaritia.client;

import codechicken.lib.render.item.IItemRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import morph.avaritia.client.render.item.WrappedItemRenderer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.mantle.client.model.BakedWrapper;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModel;
import slimeknights.tconstruct.library.client.model.BakedToolModelOverride;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModifierModel;
import slimeknights.tconstruct.library.client.model.ToolModel;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.client.model.format.ToolModelOverride;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.ToolHelper;
import xyz.phanta.tconevo.client.util.CodeChickenModel;
import xyz.phanta.tconevo.client.util.DelegateModelCache;
import xyz.phanta.tconevo.client.util.DelegatingModel;
import xyz.phanta.tconevo.client.util.ItemModelCacheKey;
import xyz.phanta.tconevo.client.util.TconReflectClient;
import xyz.phanta.tconevo.integration.avaritia.client.AvaritiaMaterialModel;
import xyz.phanta.tconevo.util.ToolUtils;

public class AvaritiaToolModel
extends ToolModel {
    public AvaritiaToolModel(ImmutableList<ResourceLocation> defaultTextures, List<MaterialModel> parts, List<MaterialModel> brokenPartBlocks, Float[] layerRotations, ModifierModel modifiers, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ImmutableList<ToolModelOverride> overrides, AmmoPosition ammoPosition) {
        super(defaultTextures, parts, brokenPartBlocks, layerRotations, modifiers, transforms, overrides, ammoPosition);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel delegate;
        return new BakedAvaritiaToolModel(delegate, (IModelState)((delegate = super.bake(state, format, bakedTextureGetter)) instanceof BakedToolModel ? new SimpleModelState(TconReflectClient.getTransforms((BakedToolModel)delegate)) : state));
    }

    private static class BakedAvaritiaToolModel
    extends BakedWrapper.Perspective
    implements DelegatingModel<ItemModelCacheKey, BakedAvaritiaToolModel>,
    IItemRenderer,
    CodeChickenModel {
        private final IBakedModel delegateModel;
        private final IModelState state;
        private final DelegateModelCache<ItemModelCacheKey, BakedAvaritiaToolModel> delegateCache;
        @Nullable
        private PartRenderer cachedPartRenderer = null;

        public BakedAvaritiaToolModel(IBakedModel parent, IModelState state) {
            super(parent, PerspectiveMapWrapper.getTransforms((IModelState)state));
            this.delegateModel = parent;
            this.state = state;
            this.delegateCache = new ToolModelCache(this);
        }

        private BakedAvaritiaToolModel(IBakedModel delegateModel, IBakedModel parent, IModelState state, DelegateModelCache<ItemModelCacheKey, BakedAvaritiaToolModel> delegateCache) {
            super(parent, PerspectiveMapWrapper.getTransforms((IModelState)state));
            this.delegateModel = delegateModel;
            this.state = state;
            this.delegateCache = delegateCache;
        }

        @Override
        public IBakedModel getParentModel() {
            return this.delegateModel;
        }

        public IModelState getTransforms() {
            return this.state;
        }

        private PartRenderer getPartRenderer(ItemStack stack) {
            if (this.cachedPartRenderer == null) {
                this.cachedPartRenderer = this.delegateModel instanceof BakedToolModel ? new ToolPartRenderer((BakedToolModel)this.delegateModel, stack) : new PartRenderer.Noop();
            }
            return this.cachedPartRenderer;
        }

        public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
            PartRenderer partRenderer = this.getPartRenderer(stack);
            partRenderer.renderUnderlays(transformType);
            WrappedItemRenderer.renderModel((IBakedModel)this.parent, (ItemStack)stack);
            partRenderer.renderOverlays(transformType);
        }

        public ItemOverrideList func_188617_f() {
            return this.delegateCache;
        }

        @Override
        public BakedAvaritiaToolModel wrapDelegate(ItemModelCacheKey delegateKey) {
            ItemStack stack;
            IBakedModel delegateModel = delegateKey.getModel();
            if (delegateModel instanceof BakedToolModel && (stack = delegateKey.getStack()) != null) {
                return new BakedAvaritiaToolModel(delegateModel, delegateModel.func_188617_f().handleItemState(delegateModel, stack, this.delegateCache.getCachedWorld(), this.delegateCache.getCachedEntity()), (IModelState)new SimpleModelState(TconReflectClient.getTransforms((BakedToolModel)delegateModel)), this.delegateCache);
            }
            return new BakedAvaritiaToolModel(delegateModel, delegateModel, this.state, this.delegateCache);
        }

        private static class ToolPartRenderer
        implements PartRenderer {
            private final List<Material> materials;
            private final int renderPartCount;
            private final AvaritiaMaterialModel.BakedAvaritiaMaterialModel[] renderablePartModels;
            private final ItemStack[] partStacks;

            ToolPartRenderer(BakedToolModel baseModel, ItemStack stack) {
                int i;
                this.materials = ToolUtils.getToolMaterials(stack);
                BakedMaterialModel[] parts = TconReflectClient.getParts(baseModel);
                this.renderPartCount = Math.min(parts.length, this.materials.size());
                this.renderablePartModels = new AvaritiaMaterialModel.BakedAvaritiaMaterialModel[this.renderPartCount];
                this.partStacks = new ItemStack[this.renderPartCount];
                if (ToolHelper.isBroken((ItemStack)stack)) {
                    BakedMaterialModel[] brokenParts = TconReflectClient.getBrokenParts(baseModel);
                    for (i = 0; i < this.renderPartCount; ++i) {
                        IBakedModel matModel;
                        BakedMaterialModel part = brokenParts[i];
                        if (part == null) {
                            part = parts[i];
                        }
                        if (!((matModel = part.getModelByIdentifier(this.materials.get((int)i).identifier)) instanceof AvaritiaMaterialModel.BakedAvaritiaMaterialModel)) continue;
                        this.renderablePartModels[i] = (AvaritiaMaterialModel.BakedAvaritiaMaterialModel)matModel;
                    }
                } else {
                    for (int i2 = 0; i2 < this.renderPartCount; ++i2) {
                        IBakedModel matModel = parts[i2].getModelByIdentifier(this.materials.get((int)i2).identifier);
                        if (!(matModel instanceof AvaritiaMaterialModel.BakedAvaritiaMaterialModel)) continue;
                        this.renderablePartModels[i2] = (AvaritiaMaterialModel.BakedAvaritiaMaterialModel)matModel;
                    }
                }
                if (stack.func_77973_b() instanceof TinkersItem) {
                    List partItemTypes = ((TinkersItem)stack.func_77973_b()).getRequiredComponents();
                    for (i = 0; i < this.renderPartCount; ++i) {
                        if (this.renderablePartModels[i] == null) continue;
                        Set partItems = ((PartMaterialType)partItemTypes.get(i)).getPossibleParts();
                        this.partStacks[i] = partItems.isEmpty() ? ItemStack.field_190927_a : ((IToolPart)partItems.iterator().next()).getItemstackWithMaterial(this.materials.get(i));
                    }
                } else {
                    Arrays.fill(this.partStacks, ItemStack.field_190927_a);
                }
            }

            @Override
            public void renderUnderlays(ItemCameraTransforms.TransformType transType) {
                for (int i = 0; i < this.renderPartCount; ++i) {
                    if (this.renderablePartModels[i] == null) continue;
                    this.renderablePartModels[i].renderUnderlay(this.partStacks[i], transType, this.materials.get(i));
                }
            }

            @Override
            public void renderOverlays(ItemCameraTransforms.TransformType transType) {
                for (int i = 0; i < this.renderPartCount; ++i) {
                    if (this.renderablePartModels[i] == null) continue;
                    this.renderablePartModels[i].renderOverlay(this.partStacks[i], transType, this.materials.get(i));
                }
            }
        }

        private static interface PartRenderer {
            public void renderUnderlays(ItemCameraTransforms.TransformType var1);

            public void renderOverlays(ItemCameraTransforms.TransformType var1);

            public static class Noop
            implements PartRenderer {
                @Override
                public void renderUnderlays(ItemCameraTransforms.TransformType transType) {
                }

                @Override
                public void renderOverlays(ItemCameraTransforms.TransformType transType) {
                }
            }
        }

        private static class ToolModelCache
        extends DelegateModelCache<ItemModelCacheKey, BakedAvaritiaToolModel> {
            public ToolModelCache(BakedAvaritiaToolModel rootModel) {
                super(rootModel);
            }

            @Override
            protected ItemModelCacheKey extractDelegateKey(IBakedModel parent, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                for (BakedToolModelOverride override : TconReflectClient.getOverrides((BakedToolModel)parent).reverse()) {
                    if (!override.matches(stack, world, entity)) continue;
                    return new ItemModelCacheKey((IBakedModel)override.bakedToolModel, stack);
                }
                return new ItemModelCacheKey(parent, stack);
            }
        }
    }
}

