/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.material;

import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.ModContainer;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.integration.conarm.material.ArmourMaterialDefinition;
import xyz.phanta.tconevo.integration.conarm.material.ArmourPartType;
import xyz.phanta.tconevo.util.LazyAccum;

public class ArmourMaterialBuilder {
    private final Material baseMaterial;
    private final List<IMaterialStats> materialStats = new ArrayList<IMaterialStats>();
    private final Map<ArmourPartType, LazyAccum<ITrait>> traits = new EnumMap<ArmourPartType, LazyAccum<ITrait>>(ArmourPartType.class);

    public ArmourMaterialBuilder(Material baseMaterial) {
        this.baseMaterial = baseMaterial;
    }

    public ArmourMaterialBuilder withStats(IMaterialStats statsObj) {
        this.materialStats.add(statsObj);
        return this;
    }

    public ArmourMaterialBuilder withStatsCore(float durability, float defense) {
        return this.withStats((IMaterialStats)new CoreMaterialStats(durability, defense));
    }

    public ArmourMaterialBuilder withStatsPlates(float durabilityMultiplier, float durability, float toughness) {
        return this.withStats((IMaterialStats)new PlatesMaterialStats(durabilityMultiplier, durability, toughness));
    }

    public ArmourMaterialBuilder withStatsTrim(float durability) {
        return this.withStats((IMaterialStats)new TrimMaterialStats(durability));
    }

    public ArmourMaterialBuilder withStatsArmour(float coreDurability, float coreDefense, float platesDurabilityMultiplier, float platesDurability, float platesToughness, float trimDurability) {
        return this.withStatsCore(coreDurability, coreDefense).withStatsPlates(platesDurabilityMultiplier, platesDurability, platesToughness).withStatsTrim(trimDurability);
    }

    public ArmourMaterialBuilder withTraits(ArmourPartType partType, LazyAccum<ITrait> traitCollector) {
        this.traits.put(partType, traitCollector);
        return this;
    }

    public ArmourMaterialBuilder withTraits(ArmourPartType partType, ITrait ... traits) {
        return this.withTraits(partType, (Accrue<ITrait> c) -> c.acceptAll((Object[])traits));
    }

    public void build() {
        try {
            ModContainer owner = TinkerRegistry.getTrace((Material)this.baseMaterial);
            if (owner != null && owner.matches((Object)TconEvoMod.INSTANCE)) {
                for (IMaterialStats statsObj : this.materialStats) {
                    TinkerRegistry.addMaterialStats((Material)this.baseMaterial, (IMaterialStats)statsObj);
                }
                ArmourMaterialDefinition.register(this.baseMaterial, this.traits);
            }
        }
        catch (Exception e) {
            TconEvoMod.LOGGER.error("Encountered exception while building armour material {}", (Object)this.baseMaterial.identifier);
            TconEvoMod.LOGGER.error("Stack trace:", (Throwable)e);
        }
    }
}

