/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.bloodmagic;

import c4.conarm.lib.traits.AbstractArmorTrait;
import com.google.common.collect.Multimap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.init.TconEvoEntityAttrs;
import xyz.phanta.tconevo.integration.bloodmagic.BloodMagicHooks;
import xyz.phanta.tconevo.integration.bloodmagic.DemonWillType;
import xyz.phanta.tconevo.trait.bloodmagic.TraitSentient;
import xyz.phanta.tconevo.util.ArmourAttributeId;

public class ArmourTraitSentient
extends AbstractArmorTrait {
    private static final ArmourAttributeId ATTR_ATTACK_DMG = new ArmourAttributeId("1b459269-5d3a-4138-a5dc-2a929ff69437", "04f90192-0a8c-48f5-a79a-f191d224445b", "6be4540c-facd-40b8-a426-66e9e8b2fa7c", "6ca879e3-02a1-4209-b9bd-da32e4cd2f38");
    private static final ArmourAttributeId ATTR_ATTACK_SPD = new ArmourAttributeId("5b4580ad-caed-42a8-8b1a-03a071f36b2b", "a554e32f-e54a-45ce-a825-31b33c402b45", "d4f0651d-ec39-435a-9bfb-91bac290ad11", "ae437435-e97e-45bd-aab8-996d4c09beb1");
    public static final ArmourAttributeId ATTR_MOVE_SPD = new ArmourAttributeId("113e32b3-49cf-41dd-8810-6fdb4e18d983", "7e853dd2-4127-4329-8a72-a45f1822da3d", "5027118b-4ac9-431a-ac5f-e6826baf708b", "4a76b326-1bf6-4b9d-9e91-507b83e586db");
    private static final ArmourAttributeId ATTR_KB_RESIST = new ArmourAttributeId("888f656f-a1e6-4a50-bd5d-e173f41477e4", "fd254722-2a88-4f13-b4fa-1124f6b1d1a6", "6088b9df-cbd6-468f-9a5d-457b0be6d67c", "f8cc449f-8f48-425f-93bf-b8702d8f345a");
    private static final ArmourAttributeId ATTR_DMG_TAKEN = new ArmourAttributeId("04929673-2a33-4bf5-bcff-78640e583805", "4272fbc5-3d7e-4d31-818e-736222a48cf5", "4e27ddc1-1bc8-4d24-9223-89fb7dcf83d2", "647adcd7-3a01-435a-bdd1-875909bb74cc");

    public ArmourTraitSentient() {
        super("tconevo.sentient", 8314595);
    }

    public int onArmorDamage(ItemStack armour, DamageSource source, int damage, int newDamage, EntityPlayer player, int slot) {
        TraitSentient.WillPower willPower = TraitSentient.getWillPower(armour);
        double cost = willPower.getArmourWillCost() * (double)newDamage;
        if (cost > 0.0) {
            BloodMagicHooks.INSTANCE.extractDemonWill(player, willPower.getWillType(), cost);
        }
        ArmourTraitSentient.updateWillPowerArmour(armour, player);
        return newDamage;
    }

    public void onArmorEquipped(ItemStack armour, EntityPlayer player, int slot) {
        ArmourTraitSentient.updateWillPowerArmour(armour, player);
    }

    public void onArmorRemoved(ItemStack armour, EntityPlayer player, int slot) {
        ArmourTraitSentient.updateWillPowerArmour(armour, player);
    }

    public float onHurt(ItemStack armour, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent event) {
        if (!player.field_70170_p.field_72995_K) {
            double cost;
            Entity attacker;
            TraitSentient.WillPower willPower = ArmourTraitSentient.updateWillPowerArmour(armour, player);
            if (willPower.getWillType() == DemonWillType.CORROSIVE && !event.getSource().func_76352_a() && (attacker = event.getSource().func_76346_g()) instanceof EntityLivingBase) {
                willPower.afterHit((EntityLivingBase)player, (EntityLivingBase)attacker);
            }
            if (source.func_76363_c() && (cost = willPower.getArmourWillCost() * (double)newDamage / 4.0) > 0.0) {
                BloodMagicHooks.INSTANCE.extractDemonWill(player, willPower.getWillType(), cost);
            }
        }
        return newDamage;
    }

    public void onArmorTick(ItemStack tool, World world, EntityPlayer player) {
        if (player.field_70173_aa % 20 == 0 && TraitSentient.getWillPower(tool).getWillType() == DemonWillType.CORROSIVE) {
            player.func_184596_c(MobEffects.field_76436_u);
            player.func_184596_c(MobEffects.field_82731_v);
        }
    }

    public void getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack, Multimap<String, AttributeModifier> attributeMap) {
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            TraitSentient.WillPower willPower = TraitSentient.getWillPower(stack);
            attributeMap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTR_ATTACK_DMG.getId(slot), "Sentient Attack Damage", willPower.getArmourAttackDamageModifier(), 0));
            attributeMap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTR_ATTACK_SPD.getId(slot), "Sentient Attack Speed", willPower.getArmourAttackSpeedModifier(), 1));
            attributeMap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ATTR_MOVE_SPD.getId(slot), "Sentient Move Speed", willPower.getArmourMoveSpeedModifier(), 1));
            attributeMap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ATTR_KB_RESIST.getId(slot), "Sentient Knockback Resist", willPower.getArmourKnockbackModifier(), 0));
            attributeMap.put((Object)TconEvoEntityAttrs.DAMAGE_TAKEN.func_111108_a(), (Object)new AttributeModifier(ATTR_DMG_TAKEN.getId(slot), "Sentient Damage Taken", -willPower.getArmourProtectionModifier(), 1));
        }
    }

    public int getPriority() {
        return 110;
    }

    private static TraitSentient.WillPower updateWillPowerArmour(ItemStack stack, EntityPlayer wearer) {
        return TraitSentient.updateWillPower(stack, wearer, TconEvoConfig.moduleBloodMagic.sentientArmourTierThresholds);
    }
}

