/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.bloodmagic;

import c4.conarm.lib.traits.AbstractArmorTrait;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.utils.ToolHelper;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.bloodmagic.BloodMagicHooks;
import xyz.phanta.tconevo.util.DamageUtils;
import xyz.phanta.tconevo.util.ToolUtils;

public class ArmourTraitSoulGuard
extends AbstractArmorTrait {
    public ArmourTraitSoulGuard() {
        super("tconevo.soul_guard", 0xBB0011);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityHurt(LivingHurtEvent event) {
        int bloodCost;
        int soulFray;
        EntityLivingBase victim = event.getEntityLiving();
        if (victim.field_70170_p.field_72995_K) {
            event.setAmount(0.0f);
            return;
        }
        if (!(victim instanceof EntityPlayer)) {
            return;
        }
        float damage = event.getAmount();
        if (damage <= 0.0f) {
            return;
        }
        DamageSource dmgSrc = event.getSource();
        if (DamageUtils.isPureDamage(dmgSrc, damage)) {
            return;
        }
        ArrayList<ItemStack> armour = new ArrayList<ItemStack>();
        for (ItemStack stack : victim.func_184193_aE()) {
            if (!this.isToolWithTrait(stack) || ToolHelper.isBroken((ItemStack)stack)) continue;
            armour.add(stack);
        }
        if (armour.isEmpty()) {
            return;
        }
        float mitigable = damage;
        if (dmgSrc.func_76363_c()) {
            mitigable -= damage * (float)TconEvoConfig.moduleBloodMagic.soulGuardPiercingPenalty;
        }
        if ((soulFray = BloodMagicHooks.INSTANCE.getSoulFrayLevel(victim)) > -1) {
            mitigable -= damage * (float)(soulFray + 1) * (float)TconEvoConfig.moduleBloodMagic.soulGuardFrayedPenalty;
        }
        if ((mitigable *= (float)TconEvoConfig.moduleBloodMagic.soulGuardDamageReduction) > 0.0f && (bloodCost = (int)Math.ceil(mitigable * (float)TconEvoConfig.moduleBloodMagic.soulGuardCost)) > 0) {
            for (ItemStack stack : armour) {
                int consumed = BloodMagicHooks.INSTANCE.extractLifePoints((EntityPlayer)victim, bloodCost, stack);
                if (consumed <= 0) continue;
                damage -= Math.max(mitigable * ((float)consumed / (float)bloodCost), 0.0f);
            }
        }
        event.setAmount(damage);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent(this.identifier, (float)TconEvoConfig.moduleBloodMagic.soulGuardDamageReduction);
    }
}

