/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.botania;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class ArmourModGaiaWill
extends ArmorModifierTrait {
    public ArmourModGaiaWill(String identifier) {
        super(identifier, 5994302);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canApplyCustom(ItemStack stack) {
        if (EntityLiving.func_184640_d((ItemStack)stack) != EntityEquipmentSlot.HEAD) {
            return false;
        }
        for (IModifier modifier : TinkerUtil.getModifiers((ItemStack)stack)) {
            if (!(modifier instanceof ArmourModGaiaWill)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        Entity attackerEntity = event.getSource().func_76346_g();
        if (attackerEntity == null || attackerEntity.field_70170_p.field_72995_K || !(attackerEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)attackerEntity;
        if (attacker.field_70143_R <= 0.0f || attacker.field_70122_E || attacker.func_70617_f_() || attacker.func_70090_H() || attacker.func_70644_a(MobEffects.field_76440_q) || attacker.func_184218_aH()) {
            return;
        }
        ItemStack helmet = attacker.func_184582_a(EntityEquipmentSlot.HEAD);
        if (this.isToolWithTrait(helmet)) {
            event.setAmount(this.applyWillEffect(attacker, event.getEntityLiving(), event.getAmount(), event.getSource()));
        }
    }

    protected abstract float applyWillEffect(EntityLivingBase var1, EntityLivingBase var2, float var3, DamageSource var4);

    public static class Verac
    extends ArmourModGaiaWill {
        public Verac() {
            super("tconevo.gaia_will_verac");
        }

        @Override
        protected float applyWillEffect(EntityLivingBase attacker, EntityLivingBase target, float amount, DamageSource dmgSrc) {
            dmgSrc.func_76348_h();
            return amount;
        }
    }

    public static class Torag
    extends ArmourModGaiaWill {
        public Torag() {
            super("tconevo.gaia_will_torag");
        }

        @Override
        protected float applyWillEffect(EntityLivingBase attacker, EntityLivingBase target, float amount, DamageSource dmgSrc) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 1));
            return amount;
        }
    }

    public static class Karil
    extends ArmourModGaiaWill {
        public Karil() {
            super("tconevo.gaia_will_karil");
        }

        @Override
        protected float applyWillEffect(EntityLivingBase attacker, EntityLivingBase target, float amount, DamageSource dmgSrc) {
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 1));
            return amount;
        }
    }

    public static class Guthan
    extends ArmourModGaiaWill {
        public Guthan() {
            super("tconevo.gaia_will_guthan");
        }

        @Override
        protected float applyWillEffect(EntityLivingBase attacker, EntityLivingBase target, float amount, DamageSource dmgSrc) {
            attacker.func_70691_i(amount / 4.0f);
            return amount;
        }
    }

    public static class Dharok
    extends ArmourModGaiaWill {
        public Dharok() {
            super("tconevo.gaia_will_dharok");
        }

        @Override
        protected float applyWillEffect(EntityLivingBase attacker, EntityLivingBase target, float amount, DamageSource dmgSrc) {
            return amount * (1.0f + (1.0f - attacker.func_110143_aJ() / attacker.func_110138_aP()) / 2.0f);
        }
    }

    public static class Ahrim
    extends ArmourModGaiaWill {
        public Ahrim() {
            super("tconevo.gaia_will_ahrim");
        }

        @Override
        protected float applyWillEffect(EntityLivingBase attacker, EntityLivingBase target, float amount, DamageSource dmgSrc) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20, 1));
            return amount;
        }
    }
}

