/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.draconicevolution;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import c4.conarm.lib.modifiers.IArmorModifyable;
import io.github.phantamanta44.libnine.util.format.FormatUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;
import xyz.phanta.tconevo.util.ToolUtils;

public class ArmourModChaosResistance
extends ArmorModifierTrait {
    public ArmourModChaosResistance() {
        super("tconevo.chaos_resistance", 203127, 5, 0);
        if (TconEvoConfig.moduleDraconicEvolution.chaosResistOnlyUsesOneModifier) {
            this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
            this.addAspects(new ModifierAspect[]{new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1)});
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static float getDamageReduction(int level) {
        return (float)level * (float)TconEvoConfig.moduleDraconicEvolution.chaosResistPercentagePerLevel;
    }

    @SubscribeEvent
    public void onEntityAttack(LivingHurtEvent event) {
        if (DraconicHooks.INSTANCE.isChaosDamage(event.getSource())) {
            int totalLevel = 0;
            for (ItemStack stack : event.getEntityLiving().func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof IArmorModifyable)) continue;
                totalLevel += ToolUtils.getTraitLevel(stack, "tconevo.chaos_resistance_armor");
            }
            if (totalLevel > 0) {
                float newDamage = event.getAmount() * (1.0f - ArmourModChaosResistance.getDamageReduction(totalLevel));
                if (newDamage > 0.0f) {
                    event.setAmount(newDamage);
                } else {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
            }
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfo(this.identifier, FormatUtils.formatPercentage((float)ArmourModChaosResistance.getDamageReduction(ToolUtils.getTraitLevel(modifierTag))));
    }
}

