/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.draconicevolution;

import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import xyz.phanta.tconevo.integration.IntegrationHooks;

public interface DraconicHooks
extends IntegrationHooks {
    public static final String MOD_ID = "draconicevolution";
    @IntegrationHooks.Inject(value="draconicevolution", sided=true)
    public static final DraconicHooks INSTANCE = new Noop();

    public static boolean isLoaded() {
        return !(INSTANCE instanceof Noop);
    }

    public Optional<ItemStack> getItemEnderEnergyManipulator();

    public Optional<ItemStack> getItemWyvernEnergyCore();

    public Optional<ItemStack> getItemDraconicEnergyCore();

    public Optional<ItemStack> getItemChaosShard();

    public Optional<ItemStack> getItemDragonHeart();

    public Optional<ItemStack> getItemReactorStabilizer();

    public Optional<ItemStack> getItemWyvernCapacitor();

    public Optional<ItemStack> getItemDraconicCapacitor();

    public void addUpgradeRecipes(Modifier var1, String var2);

    public boolean isReaperEnchantment(Enchantment var1);

    public void playShieldHitEffect(EntityPlayer var1, float var2);

    public boolean isShieldEnabled(EntityPlayer var1);

    @Nullable
    public IPair<Float, Float> applyShieldDamageModifiers(EntityPlayer var1, EntityPlayer var2, float var3, float var4);

    public boolean inflictEntropy(ItemStack var1, float var2);

    public int burnArmourEnergy(ItemStack var1, float var2, int var3, int var4);

    public DamageSource getChaosDamage(EntityLivingBase var1);

    public boolean isChaosDamage(DamageSource var1);

    default public void playChaosEffect(World world, double x, double y, double z) {
    }

    public static class Noop
    implements DraconicHooks {
        @Override
        public Optional<ItemStack> getItemEnderEnergyManipulator() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemWyvernEnergyCore() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemDraconicEnergyCore() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemChaosShard() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemDragonHeart() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemReactorStabilizer() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemWyvernCapacitor() {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> getItemDraconicCapacitor() {
            return Optional.empty();
        }

        @Override
        public void addUpgradeRecipes(Modifier upgradeMod, String upgradeKey) {
        }

        @Override
        public boolean isReaperEnchantment(Enchantment ench) {
            return false;
        }

        @Override
        public void playShieldHitEffect(EntityPlayer player, float shieldPower) {
            MinecraftServer server = player.field_70170_p.func_73046_m();
            if (server != null) {
                server.func_184103_al().func_148543_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0, player.field_71093_bK, (Packet)new SPacketAnimation((Entity)player, 5));
            } else {
                player.func_71047_c((Entity)player);
            }
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187603_D, SoundCategory.PLAYERS, 1.0f, 1.0f + 0.5f * shieldPower);
        }

        @Override
        public boolean isShieldEnabled(EntityPlayer player) {
            return true;
        }

        @Override
        @Nullable
        public IPair<Float, Float> applyShieldDamageModifiers(EntityPlayer victim, EntityPlayer attacker, float shieldPoints, float damage) {
            return null;
        }

        @Override
        public boolean inflictEntropy(ItemStack stack, float amount) {
            return false;
        }

        @Override
        public int burnArmourEnergy(ItemStack stack, float fraction, int minBurn, int maxBurn) {
            return 0;
        }

        @Override
        public DamageSource getChaosDamage(EntityLivingBase attacker) {
            return new EntityDamageSource("chaos", (Entity)attacker).func_76348_h().func_151518_m();
        }

        @Override
        public boolean isChaosDamage(DamageSource dmgSrc) {
            return dmgSrc.field_76373_n.equals("chaos");
        }
    }
}

